/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.original.zkdist;

import com.taotao.boot.common.utils.log.LogUtils;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class DistributedServer {
    private static final String connectString = "192.168.56.100:2181,192.168.56.101:2181,192.168.56.102:2181";
    private static final int sessionTimeout = 2000;
    private static final String parentNode = "/servers";
    private ZooKeeper zk = null;

    public void getConnect() throws Exception {
        this.zk = new ZooKeeper(connectString, 2000, new Watcher(){

            public void process(WatchedEvent event) {
                LogUtils.info((String)(String.valueOf(event.getType()) + "---" + event.getPath()), (Object[])new Object[0]);
                try {
                    DistributedServer.this.zk.getChildren("/", true);
                }
                catch (Exception e) {
                    LogUtils.error((Throwable)e);
                }
            }
        });
    }

    public void registerServer(String hostname) throws Exception {
        String create = this.zk.create("/servers/server", hostname.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        LogUtils.info((String)(hostname + "is online.." + create), (Object[])new Object[0]);
    }

    public void handleBussiness(String hostname) throws InterruptedException {
        LogUtils.info((String)(hostname + "start working....."), (Object[])new Object[0]);
        Thread.sleep(Long.MAX_VALUE);
    }

    public static void main(String[] args) throws Exception {
        DistributedServer server = new DistributedServer();
        server.getConnect();
        server.registerServer("zk2");
        server.handleBussiness("zk2");
    }
}

