/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.original.zklock;

import com.taotao.boot.common.utils.log.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class DistributedClientLock {
    private static final int SESSION_TIMEOUT = 2000;
    private String hosts = "192.168.56.100:2181,192.168.56.101:2181,192.168.56.102:2181";
    private String groupNode = "locks";
    private String subNode = "sub";
    private boolean haveLock = false;
    private ZooKeeper zk;
    private volatile String thisPath;

    public void connectZookeeper() throws Exception {
        this.zk = new ZooKeeper(this.hosts, 2000, new Watcher(){

            public void process(WatchedEvent event) {
                try {
                    if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged && event.getPath().equals("/" + DistributedClientLock.this.groupNode)) {
                        List childrenNodes = DistributedClientLock.this.zk.getChildren("/" + DistributedClientLock.this.groupNode, true);
                        String thisNode = DistributedClientLock.this.thisPath.substring(("/" + DistributedClientLock.this.groupNode + "/").length());
                        Collections.sort(childrenNodes);
                        if (childrenNodes.indexOf(thisNode) == 0) {
                            DistributedClientLock.this.doSomething();
                            DistributedClientLock.this.thisPath = DistributedClientLock.this.zk.create("/" + DistributedClientLock.this.groupNode + "/" + DistributedClientLock.this.subNode, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
                        }
                    }
                }
                catch (Exception e) {
                    LogUtils.error((Throwable)e);
                }
            }
        });
        this.thisPath = this.zk.create("/" + this.groupNode + "/" + this.subNode, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        Thread.sleep(new Random().nextInt(1000));
        List childrenNodes = this.zk.getChildren("/" + this.groupNode, true);
        if (childrenNodes.size() == 1) {
            this.doSomething();
            this.thisPath = this.zk.create("/" + this.groupNode + "/" + this.subNode, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        }
    }

    private void doSomething() throws Exception {
        try {
            LogUtils.info((String)("gain lock: " + this.thisPath), (Object[])new Object[0]);
            Thread.sleep(2000L);
        }
        finally {
            LogUtils.info((String)("finished: " + this.thisPath), (Object[])new Object[0]);
            this.zk.delete(this.thisPath, -1);
        }
    }

    public static void main(String[] args) throws Exception {
        DistributedClientLock dl = new DistributedClientLock();
        dl.connectZookeeper();
        Thread.sleep(Long.MAX_VALUE);
    }
}

