/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.support;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.taotao.boot.common.utils.log.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;

public class LeaderElectionService {
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("zookeeper-init").build();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, this.threadFactory);
    private final CuratorFramework curatorFramework;
    private final LeaderLatch leaderLatch;
    private final String zkPath;

    public LeaderElectionService(String scene, String serverId, LeaderLatchListener listener, CuratorFramework curatorFramework) {
        this.curatorFramework = Objects.isNull(curatorFramework) ? CuratorFrameworkFactory.newClient((String)"127.0.0.1:2181", (RetryPolicy)new ExponentialBackoffRetry(1000, 3)) : curatorFramework;
        this.zkPath = String.format("/election/%s", scene);
        this.leaderLatch = new LeaderLatch(curatorFramework, this.zkPath, serverId);
        this.leaderLatch.addListener(listener);
        this.executorService.execute(this::init);
    }

    private void init() {
        this.initStep1();
        this.initStep2();
        this.initStep3();
        this.executorService.shutdown();
    }

    private void initStep1() {
        while (true) {
            try {
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(this.zkPath);
            }
            catch (Exception e) {
                LogUtils.error((String)"create parent path exception is ", (Object[])new Object[]{e});
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    private void initStep2() {
        while (true) {
            try {
                this.curatorFramework.start();
            }
            catch (Exception e) {
                LogUtils.error((String)"create parent path exception is ", (Object[])new Object[]{e});
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    private void initStep3() {
        while (true) {
            try {
                this.leaderLatch.start();
            }
            catch (Exception e) {
                LogUtils.error((String)"create parent path exception is ", (Object[])new Object[]{e});
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    public void close() {
        if (this.leaderLatch != null) {
            try {
                this.leaderLatch.close();
            }
            catch (Exception e) {
                LogUtils.error((String)"leader latch close exception ", (Object[])new Object[]{e});
            }
        }
        if (this.curatorFramework != null) {
            try {
                this.curatorFramework.close();
            }
            catch (Exception e) {
                LogUtils.error((String)"frame close exception ", (Object[])new Object[]{e});
            }
        }
    }

    public static class ConnListener
    implements ConnectionStateListener {
        private final String path;
        private final String serverId;

        public ConnListener(String path, String serverId) {
            this.path = path;
            this.serverId = serverId;
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState != ConnectionState.LOST) {
                return;
            }
            while (true) {
                try {
                    client.getZookeeperClient().blockUntilConnectedOrTimedOut();
                    ((ACLBackgroundPathAndBytesable)client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(this.path, this.serverId.getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    LogUtils.error((String)"rebuild exception ", (Object[])new Object[]{e});
                    continue;
                }
                break;
            }
        }
    }
}

