/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.support;

import com.taotao.boot.common.utils.log.LogUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;

public class ZkIdGenerator {
    private static final String PATH = "/zk-id";
    private final AtomicInteger atomicInteger = new AtomicInteger();
    private final AtomicReference<String> machinePrefix = new AtomicReference<String>("");
    private static final String[] AUX_ARRAY = new String[]{"", "0", "00", "000", "0000", "00000"};
    private final CuratorFramework curatorFramework;

    public ZkIdGenerator(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    public Optional<String> genId() {
        if ("".equals(this.machinePrefix.get())) {
            this.acquireMachinePrefix();
        }
        if (this.machinePrefix.get().isEmpty()) {
            return Optional.empty();
        }
        LocalDateTime now = LocalDateTime.now();
        int aux = this.atomicInteger.getAndAccumulate(1, (left, right) -> {
            int val = left + right;
            return val > 99999 ? 1 : val;
        });
        String time = ZkIdGenerator.conv2Str(now.getDayOfYear(), 3) + ZkIdGenerator.conv2Str(now.getHour(), 2) + ZkIdGenerator.conv2Str(now.getMinute(), 2) + ZkIdGenerator.conv2Str(now.getSecond(), 2);
        String suffix = ZkIdGenerator.conv2Str(aux, 5);
        return Optional.of(this.machinePrefix.get() + time + suffix);
    }

    private synchronized void acquireMachinePrefix() {
        if (!this.machinePrefix.get().isEmpty()) {
            return;
        }
        try {
            String s = this.curatorFramework.getZookeeperClient().getZooKeeper().create(PATH, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            if (s.length() > 3) {
                this.machinePrefix.compareAndSet("", s.substring(s.length() - 3));
            }
        }
        catch (Exception e) {
            LogUtils.error((String)"connect to zookeeper failed, exception is ", (Object[])new Object[]{e});
        }
    }

    private static String conv2Str(int value, int length) {
        if (length > 5) {
            throw new IllegalArgumentException("length should be less than 5");
        }
        String str = String.valueOf(value);
        return AUX_ARRAY[length - str.length()] + str;
    }
}

