/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.support;

import com.taotao.boot.common.utils.log.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.DeleteBuilderMain;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.zookeeper.CreateMode;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.util.Assert;

public class ZookeeperTemplate {
    private final CuratorFramework client;

    public ZookeeperTemplate(CuratorFramework client) {
        this.client = client;
    }

    public String createNode(String path, String node) {
        return this.createNode(path, node, CreateMode.PERSISTENT);
    }

    public String createNode(String path, CreateMode mode) {
        try {
            return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(mode)).forPath(path);
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public void setNodeData(String path, String nodeData) {
        try {
            this.client.setData().forPath(path, nodeData.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }

    public void createNodeAndData(CreateMode mode, String path, String nodeData) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, nodeData.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }

    public String getNodeData(String path) {
        try {
            byte[] dataByte = (byte[])this.client.getData().forPath(path);
            String data = new String(dataByte, StandardCharsets.UTF_8);
            if (StrUtil.isNotEmpty((CharSequence)data)) {
                return data;
            }
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
        return null;
    }

    public List<String> getNodeChild(String path) {
        List<String> nodeChildDataList = new ArrayList<String>();
        try {
            nodeChildDataList = (List)this.client.getChildren().forPath(path);
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
        return nodeChildDataList;
    }

    public void deleteNode(String path, Boolean recursive) {
        try {
            if (recursive.booleanValue()) {
                ((ChildrenDeletable)this.client.delete().guaranteed()).deletingChildrenIfNeeded().forPath(path);
            } else {
                ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(path);
            }
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }

    public void addWatcherWithTreeCache(String path) {
        if (null == this.client) {
            throw new RuntimeException("there is not connect to zkServer...");
        }
        CuratorCache treeCache = CuratorCache.build((CuratorFramework)this.client, (String)path, (CuratorCache.Options[])new CuratorCache.Options[0]);
        CuratorCacheListener listener = (type, oldData, data) -> LogUtils.info((String)"\u8282\u70b9\u8def\u5f84 --{} ,\u8282\u70b9\u4e8b\u4ef6\u7c7b\u578b: {} , \u8282\u70b9\u503c\u4e3a: {}", (Object[])new Object[]{Objects.nonNull(data.getData()) ? Arrays.toString(data.getData()) : "\u65e0\u6570\u636e", type});
        treeCache.listenable().addListener((Object)listener);
        try {
            treeCache.start();
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }

    public void addWatcherWithChildCache(String path) {
        if (null == this.client) {
            throw new RuntimeException("there is not connect to zkServer...");
        }
        CuratorCache pathChildrenCache = CuratorCache.build((CuratorFramework)this.client, (String)path, (CuratorCache.Options[])new CuratorCache.Options[0]);
        CuratorCacheListener listener = (type, oldData, data) -> LogUtils.info((String)"event path is --{} ,event type is {}", (Object[])new Object[]{data.getData(), type});
        pathChildrenCache.listenable().addListener((Object)listener);
        try {
            pathChildrenCache.start();
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }

    public void addWatcherWithNodeCache(String path) {
        if (null == this.client) {
            throw new RuntimeException("there is not connect to zkServer...");
        }
        CuratorCache nodeCache = CuratorCache.build((CuratorFramework)this.client, (String)path, (CuratorCache.Options[])new CuratorCache.Options[0]);
        CuratorCacheListener listener = (type, oldData, data) -> {
            Optional currentData = nodeCache.get(path);
            LogUtils.info((String)"{} Znode data is chagnge,new data is ---  {}", (Object[])new Object[]{((ChildData)currentData.get()).getPath(), new String(((ChildData)currentData.get()).getData())});
        };
        nodeCache.listenable().addListener((Object)listener);
        try {
            nodeCache.start();
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }

    public String createNode(String path, String node, CreateMode createMode) {
        try {
            path = this.buildPath(path, node);
            ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().creatingParentsIfNeeded().withMode(createMode)).forPath(path);
            return path;
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public String createNode(String path, String node, String value) {
        try {
            return this.createNode(path, node, value, CreateMode.PERSISTENT);
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public String createNode(String path, String node, String value, CreateMode createMode) {
        Assert.isTrue((boolean)StrUtil.isNotEmpty((CharSequence)value), (String)"zookeeper\u8282\u70b9\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            path = this.buildPath(path, node);
            ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().creatingParentsIfNeeded().withMode(createMode)).forPath(path, value.getBytes());
            return path;
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public String get(String path, String node) {
        try {
            path = this.buildPath(path, node);
            byte[] bytes = (byte[])this.client.getData().forPath(path);
            if (bytes.length > 0) {
                return new String(bytes);
            }
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
        return null;
    }

    public String update(String path, String node, String value) {
        Assert.isTrue((boolean)StrUtil.isNotEmpty((CharSequence)value), (String)"zookeeper\u8282\u70b9\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            path = this.buildPath(path, node);
            this.client.setData().forPath(path, value.getBytes());
            return path;
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public void delete(String path, String node) {
        path = this.buildPath(path, node);
        try {
            ((DeleteBuilderMain)this.client.delete().quietly()).deletingChildrenIfNeeded().forPath(path);
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }

    public List<String> getChildren(String path) {
        if (StrUtil.isEmpty((CharSequence)path)) {
            return null;
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        try {
            return (List)this.client.getChildren().forPath((String)path);
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public boolean exists(String path, String node) {
        List<String> list = this.getChildren(path);
        return CollUtil.isNotEmpty(list) && list.contains(node);
    }

    public void watchNode(String path, NodeCacheListener listener) {
        CuratorCacheListener curatorCacheListener = CuratorCacheListener.builder().forNodeCache(listener).build();
        CuratorCache curatorCache = CuratorCache.builder((CuratorFramework)this.client, (String)path).build();
        curatorCache.listenable().addListener((Object)curatorCacheListener);
        curatorCache.start();
    }

    public void watchChildren(String path, PathChildrenCacheListener listener) {
        CuratorCacheListener curatorCacheListener = CuratorCacheListener.builder().forPathChildrenCache(path, this.client, listener).build();
        CuratorCache curatorCache = CuratorCache.builder((CuratorFramework)this.client, (String)path).build();
        curatorCache.listenable().addListener((Object)curatorCacheListener);
        curatorCache.start();
    }

    public void watchTree(String path, int maxDepth, TreeCacheListener listener) {
        CuratorCacheListener curatorCacheListener = CuratorCacheListener.builder().forTreeCache(this.client, listener).build();
        CuratorCache curatorCache = CuratorCache.builder((CuratorFramework)this.client, (String)path).build();
        curatorCache.listenable().addListener((Object)curatorCacheListener);
        curatorCache.start();
    }

    private String buildPath(String path, String node) {
        Assert.isTrue((StrUtil.isNotEmpty((CharSequence)path) && StrUtil.isNotEmpty((CharSequence)node) ? 1 : 0) != 0, (String)"zookeeper\u8def\u5f84\u6216\u8005\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if ("/".equals(path)) {
            return (String)path + node;
        }
        return (String)path + "/" + node;
    }

    public boolean exists(String path) {
        try {
            return this.client.checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return false;
        }
    }
}

