/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.alibaba.nacos.listener;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.Listener;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
public class NacosConfigListener
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(NacosConfigListener.class, (String)"taotao-cloud-starter-core", (String[])new String[0]);
    }

    @com.alibaba.nacos.api.config.annotation.NacosConfigListener(dataId="taotao-cloud", type=ConfigType.YAML)
    public void onReceived(Properties value) {
        LogUtils.info((String)"taotao cloud on received from nacos properties data : {}", (Object[])new Object[]{value});
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.cloud.nacos.config", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class StandardNacosConfigListener
    implements InitializingBean {
        @Value(value="${spring.application.name}")
        private String appName;
        @Autowired
        private NacosConfigManager nacosConfigManager;

        public void afterPropertiesSet() throws Exception {
            this.nacosConfigManager.getConfigService().addListener("test", "DEFAULT_GROUP", new Listener(){

                public Executor getExecutor() {
                    return null;
                }

                public void receiveConfigInfo(String configInfo) {
                    LogUtils.info((String)"taotao cloud on received from nacos config info : {}", (Object[])new Object[]{configInfo});
                }
            });
        }
    }
}

