/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.alibaba.seata.configuration;

import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.alibaba.seata.properties.SeataProperties;
import com.taotao.cloud.common.utils.log.LogUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import io.seata.core.context.RootContext;
import io.seata.spring.annotation.datasource.EnableAutoDataSourceProxy;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.filter.OncePerRequestFilter;

@AutoConfiguration
@EnableAutoDataSourceProxy
@EnableConfigurationProperties(value={SeataProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.alibaba.seata", name={"enabled"}, havingValue="true")
public class SeataAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SeataAutoConfiguration.class, (String)"taotao-cloud-starter-alibaba-seata", (String[])new String[0]);
    }

    @Bean
    public SeataXidFilter seataXidFilter() {
        return new SeataXidFilter();
    }

    @Bean
    @ConditionalOnClass(value={RequestInterceptor.class})
    public SeataInterceptor seataInterceptor() {
        return new SeataInterceptor();
    }

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    public DetectTable detectTable(DataSource dataSource) {
        return new DetectTable(dataSource);
    }

    public static class SeataXidFilter
    extends OncePerRequestFilter {
        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            String restXid = request.getHeader("xid");
            if (StrUtil.isNotBlank((CharSequence)restXid)) {
                RootContext.bind((String)restXid);
                LogUtils.info((String)("bind[" + restXid + "] to RootContext"), (Object[])new Object[0]);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static class SeataInterceptor
    implements RequestInterceptor {
        public void apply(RequestTemplate template) {
            String xid = RootContext.getXID();
            if (StrUtil.isNotBlank((CharSequence)xid)) {
                template.header("xid", new String[]{xid});
            }
        }
    }

    public static class DetectTable
    implements ApplicationRunner {
        public static final String undoLogSql = "CREATE TABLE IF NOT EXISTS `undo_log` (\n\t\t\t                             `id` bigint(20) NOT NULL AUTO_INCREMENT,\n\t\t\t                             `branch_id` bigint(20) NOT NULL,\n\t\t\t                             `xid` varchar(100) NOT NULL,\n\t\t\t                             `context` varchar(128) NOT NULL,\n\t\t\t                             `rollback_info` longblob NOT NULL,\n\t\t\t                             `log_status` int(11) NOT NULL,\n\t\t\t                             `log_created` datetime NOT NULL,\n\t\t\t                             `log_modified` datetime NOT NULL,\n\t\t\t                             PRIMARY KEY (`id`),\n\t\t\t                             UNIQUE KEY `ux_undo_log` (`xid`,`branch_id`)\n\t\t\t                           ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;\n";
        private final DataSource dataSource;

        public DetectTable(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void run(ApplicationArguments args) throws Exception {
            try {
                this.dataSource.getConnection().prepareStatement(undoLogSql).execute();
            }
            catch (SQLException e) {
                LogUtils.error((String)"\u521b\u5efa[seata] undo_log\u8868\u9519\u8bef\u3002", (Object[])new Object[]{e});
            }
        }
    }
}

