/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.alibaba.sentinel.configuration;

import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.RequestOriginParser;
import com.taotao.cloud.alibaba.sentinel.properties.SentinelProperties;
import com.taotao.cloud.common.utils.log.LogUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={SentinelFeignAutoConfiguration.class})
@EnableConfigurationProperties(value={SentinelProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.alibaba.sentinel", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SentinelAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SentinelAutoConfiguration.class, (String)"taotao-cloud-starter-alibaba-sentinel", (String[])new String[0]);
    }

    @Bean
    public RequestOriginParser requestOriginParser() {
        return new HeaderRequestOriginParser();
    }

    public static class HeaderRequestOriginParser
    implements RequestOriginParser {
        private static final String ALLOW = "Allow";

        public String parseOrigin(HttpServletRequest request) {
            return request.getHeader(ALLOW);
        }
    }
}

