/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.alibaba.sentinel.enhance;

import com.google.common.base.Objects;
import com.taotao.cloud.common.model.Result;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class CustomFallback<T>
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CustomFallback.class);
    private final Class<T> targetType;
    private final String targetName;
    private final Throwable cause;

    public CustomFallback(Class<T> targetType, String targetName, Throwable cause) {
        this.targetType = targetType;
        this.targetName = targetName;
        this.cause = cause;
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String errorMessage = this.cause.getMessage();
        String path = this.targetType.getName() + "/" + method.getName();
        Result result = Result.fail((String)path);
        log.error("Feign remote call fallback : [{}.{}] serviceId:[{}] message:[{}]", new Object[]{this.targetType.getName(), method.getName(), this.targetName, errorMessage});
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFallback that = (CustomFallback)o;
        return Objects.equal(this.targetType, that.targetType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.targetType});
    }
}

