/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.cache.redis.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taotao.cloud.cache.redis.enums.SerializerType;
import com.taotao.cloud.cache.redis.properties.CacheManagerProperties;
import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import org.redisson.api.RedissonClient;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.cloud.cache.redis", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={RedisProperties.class, CacheManagerProperties.class, com.taotao.cloud.cache.redis.properties.RedisProperties.class})
public class RedisAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RedisAutoConfiguration.class, (String)"taotao-cloud-starter-cache-redis", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisSerializer.class})
    public RedisSerializer<Object> redisSerializer(CacheManagerProperties properties, ObjectProvider<ObjectMapper> objectProvider) {
        SerializerType serializerType = properties.getSerializerType();
        if (SerializerType.JDK == serializerType) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            return new JdkSerializationRedisSerializer(classLoader);
        }
        return new GenericJackson2JsonRedisSerializer(JsonUtils.MAPPER);
    }

    @Bean
    public RedisConnectionFactory redissonConnectionFactory(RedissonClient redissonClient) {
        return new RedissonConnectionFactory(redissonClient);
    }

    @Bean
    @ConditionalOnClass(value={RedisOperations.class})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory, RedisSerializer<Object> redisSerializer) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setValueSerializer(redisSerializer);
        template.setHashValueSerializer(redisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public RedisRepository redisRepository(RedisTemplate<String, Object> redisTemplate) {
        return new RedisRepository(redisTemplate, false);
    }

    @Bean
    @ConditionalOnMissingBean(value={ValueOperations.class})
    public ValueOperations<String, Object> valueOperations(RedisTemplate<String, Object> micaRedisTemplate) {
        return micaRedisTemplate.opsForValue();
    }

    @Bean(value={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory factory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(factory);
        return template;
    }
}

