/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.cache.redis.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisKeyExpiredEvent;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.scheduling.annotation.Async;

@AutoConfiguration
@ConditionalOnBean(value={RedissonClient.class})
@ConditionalOnProperty(prefix="taotao.cloud.redis.key-expired-event.enable", value={"true"}, matchIfMissing=true)
public class RedisKeyExpiredEventAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RedisKeyExpiredEventAutoConfiguration.class, (String)"taotao-cloud-starter-cache-redis", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }

    @Bean
    @ConditionalOnMissingBean
    public KeyExpirationEventMessageListener keyExpirationEventMessageListener(RedisMessageListenerContainer listenerContainer) {
        return new KeyExpirationEventMessageListener(listenerContainer);
    }

    @Async
    @EventListener
    public void onRedisKeyExpiredEvent(RedisKeyExpiredEvent<Object> event) {
        LogUtils.info((String)event.toString(), (Object[])new Object[0]);
    }
}

