/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.cache.redis.configuration;

import com.taotao.cloud.cache.redis.properties.CacheManagerProperties;
import com.taotao.cloud.cache.redis.stream.DefaultRStreamTemplate;
import com.taotao.cloud.cache.redis.stream.RStreamListenerDetector;
import com.taotao.cloud.cache.redis.stream.RStreamTemplate;
import com.taotao.cloud.common.constant.CommonConstant;
import com.taotao.cloud.common.utils.io.NetUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.util.ErrorHandler;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.cloud.cache.redis.cache-manager.stream", name={"enable"}, havingValue="true")
public class RedisStreamAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RedisStreamAutoConfiguration.class, (String)"taotao-cloud-starter-cache-redis", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    public StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, byte[]>> streamMessageListenerContainerOptions(CacheManagerProperties properties, ObjectProvider<ErrorHandler> errorHandlerObjectProvider) {
        Duration pollTimeout;
        StreamMessageListenerContainer.StreamMessageListenerContainerOptionsBuilder builder = StreamMessageListenerContainer.StreamMessageListenerContainerOptions.builder().keySerializer(RedisSerializer.string()).hashKeySerializer(RedisSerializer.string()).hashValueSerializer(RedisSerializer.byteArray());
        CacheManagerProperties.Stream streamProperties = properties.getStream();
        Integer pollBatchSize = streamProperties.getPollBatchSize();
        if (pollBatchSize != null && pollBatchSize > 0) {
            builder.batchSize(pollBatchSize.intValue());
        }
        if ((pollTimeout = streamProperties.getPollTimeout()) != null && !pollTimeout.isNegative()) {
            builder.pollTimeout(pollTimeout);
        }
        errorHandlerObjectProvider.ifAvailable(arg_0 -> ((StreamMessageListenerContainer.StreamMessageListenerContainerOptionsBuilder)builder).errorHandler(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public StreamMessageListenerContainer<String, MapRecord<String, String, byte[]>> streamMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, byte[]>> streamMessageListenerContainerOptions) {
        return StreamMessageListenerContainer.create((RedisConnectionFactory)redisConnectionFactory, streamMessageListenerContainerOptions);
    }

    @Bean
    @ConditionalOnMissingBean
    public RStreamListenerDetector streamListenerDetector(StreamMessageListenerContainer<String, MapRecord<String, String, byte[]>> streamMessageListenerContainer, RedisTemplate<String, Object> redisTemplate, ObjectProvider<ServerProperties> serverPropertiesObjectProvider, CacheManagerProperties properties, Environment environment) {
        String consumerName;
        CacheManagerProperties.Stream streamProperties = properties.getStream();
        Object consumerGroup = streamProperties.getConsumerGroup();
        if (StringUtils.isBlank((String)consumerGroup)) {
            String appName = environment.getRequiredProperty(CommonConstant.SPRING_APP_NAME_KEY);
            String profile = environment.getProperty(CommonConstant.ACTIVE_PROFILES_PROPERTY);
            Object object = consumerGroup = StringUtils.isBlank((String)profile) ? appName + ":" : appName + ":" + profile;
        }
        if (StringUtils.isBlank((String)(consumerName = streamProperties.getConsumerName()))) {
            StringBuilder consumerNameBuilder = new StringBuilder(NetUtils.getHostIp());
            serverPropertiesObjectProvider.ifAvailable(serverProperties -> consumerNameBuilder.append(':').append(serverProperties.getPort()));
            consumerName = consumerNameBuilder.toString();
        }
        return new RStreamListenerDetector(streamMessageListenerContainer, redisTemplate, (String)consumerGroup, consumerName);
    }

    @Bean
    public RStreamTemplate streamTemplate(RedisTemplate<String, Object> redisTemplate) {
        return new DefaultRStreamTemplate(redisTemplate);
    }
}

