/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.cache.redis.model;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.cache.redis.model.CacheHashKey;
import com.taotao.cloud.cache.redis.model.CacheKey;
import java.time.Duration;
import java.util.ArrayList;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@FunctionalInterface
public interface CacheKeyBuilder {
    @NonNull
    default public String getTenant() {
        return "";
    }

    @NonNull
    public String getPrefix();

    @Nullable
    default public Duration getExpire() {
        return null;
    }

    default public CacheKey key(Object ... suffix) {
        String field = suffix.length > 0 ? Convert.toStr((Object)suffix[0], (String)"") : "";
        return this.hashFieldKey(field, suffix);
    }

    default public CacheHashKey hashFieldKey(@NonNull Object field, Object ... suffix) {
        String key = this.getKey(suffix);
        return new CacheHashKey(key, field, this.getExpire());
    }

    default public CacheHashKey hashKey(Object ... suffix) {
        String key = this.getKey(suffix);
        return new CacheHashKey(key, null, this.getExpire());
    }

    default public String getKey(Object ... suffix) {
        ArrayList<String> regionList = new ArrayList<String>();
        String tenant = this.getTenant();
        if (StrUtil.isNotEmpty((CharSequence)tenant)) {
            regionList.add(tenant);
        }
        String prefix = this.getPrefix();
        regionList.add(prefix);
        for (Object s : suffix) {
            if (!ObjectUtil.isNotEmpty((Object)s)) continue;
            regionList.add(String.valueOf(s));
        }
        return CollUtil.join(regionList, (CharSequence)":");
    }
}

