/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.canal.configuration;

import com.taotao.cloud.canal.interfaces.CanalClient;
import com.taotao.cloud.canal.model.SimpleCanalClient;
import com.taotao.cloud.canal.properties.CanalProperties;
import com.taotao.cloud.canal.runner.CanalApplicationRunner;
import com.taotao.cloud.common.utils.log.LogUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={CanalProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.canal", name={"enabled"}, havingValue="true")
public class CanalAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(CanalAutoConfiguration.class, (String)"taotao-cloud-starter-canal", (String[])new String[0]);
    }

    @Bean
    public CanalClient canalClient(CanalProperties properties) {
        return new SimpleCanalClient(properties);
    }

    @Bean
    public CanalApplicationRunner canalApplicationRunner(CanalClient canalClient) {
        return new CanalApplicationRunner(canalClient);
    }
}

