/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.captcha.support.behavior.configuration;

import com.taotao.cloud.captcha.support.behavior.renderer.JigsawCaptchaRenderer;
import com.taotao.cloud.captcha.support.behavior.renderer.WordClickCaptchaRenderer;
import com.taotao.cloud.captcha.support.core.provider.ResourceProvider;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class BehaviorCaptchaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BehaviorCaptchaConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("SDK [Engine Captcha Behavior] Auto Configure.");
    }

    @Bean(value={"JIGSAW"})
    @ConditionalOnBean(value={ResourceProvider.class})
    public JigsawCaptchaRenderer jigsawCaptchaRenderer(ResourceProvider resourceProvider) {
        JigsawCaptchaRenderer jigsawCaptchaRenderer = new JigsawCaptchaRenderer();
        jigsawCaptchaRenderer.setResourceProvider(resourceProvider);
        log.trace("Bean [Jigsaw Captcha Renderer] Auto Configure.");
        return jigsawCaptchaRenderer;
    }

    @Bean(value={"WORD_CLICK"})
    @ConditionalOnBean(value={ResourceProvider.class})
    public WordClickCaptchaRenderer wordClickCaptchaRenderer(ResourceProvider resourceProvider) {
        WordClickCaptchaRenderer wordClickCaptchaRenderer = new WordClickCaptchaRenderer();
        wordClickCaptchaRenderer.setResourceProvider(resourceProvider);
        log.trace("Bean [Word Click Captcha Renderer] Auto Configure.");
        return wordClickCaptchaRenderer;
    }
}

