/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.captcha.support.behavior.renderer;

import cn.hutool.core.util.IdUtil;
import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.captcha.support.behavior.definition.AbstractBehaviorRenderer;
import com.taotao.cloud.captcha.support.behavior.dto.WordClickCaptcha;
import com.taotao.cloud.captcha.support.behavior.renderer.WordClickObfuscator;
import com.taotao.cloud.captcha.support.core.definition.domain.Coordinate;
import com.taotao.cloud.captcha.support.core.definition.domain.Metadata;
import com.taotao.cloud.captcha.support.core.definition.enums.CaptchaCategory;
import com.taotao.cloud.captcha.support.core.definition.enums.FontStyle;
import com.taotao.cloud.captcha.support.core.dto.Captcha;
import com.taotao.cloud.captcha.support.core.dto.Verification;
import com.taotao.cloud.captcha.support.core.exception.CaptchaHasExpiredException;
import com.taotao.cloud.captcha.support.core.exception.CaptchaMismatchException;
import com.taotao.cloud.captcha.support.core.exception.CaptchaParameterIllegalException;
import com.taotao.cloud.captcha.support.core.provider.RandomProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WordClickCaptchaRenderer
extends AbstractBehaviorRenderer {
    private WordClickCaptcha wordClickCaptcha;
    @Autowired
    private RedisRepository redisRepository;
    private static final Duration DEFAULT_EXPIRE = Duration.ofMinutes(1L);

    private Font getFont() {
        int fontSize = this.getCaptchaProperties().getWordClick().getFontSize();
        String fontName = this.getCaptchaProperties().getWordClick().getFontName();
        FontStyle fontStyle = this.getCaptchaProperties().getWordClick().getFontStyle();
        return this.getResourceProvider().getFont(fontName, fontSize, fontStyle);
    }

    @Override
    public String getCategory() {
        return CaptchaCategory.WORD_CLICK.getConstant();
    }

    @Override
    public Captcha getCapcha(String key) {
        String identity = key;
        if (StringUtils.isBlank((CharSequence)identity)) {
            identity = IdUtil.fastUUID();
        }
        Metadata metadata = this.draw();
        WordClickObfuscator wordClickObfuscator = new WordClickObfuscator(metadata.getWords(), metadata.getCoordinates());
        WordClickCaptcha wordClickCaptcha = new WordClickCaptcha();
        wordClickCaptcha.setIdentity(identity);
        wordClickCaptcha.setWordClickImageBase64(metadata.getWordClickImageBase64());
        wordClickCaptcha.setWords(wordClickObfuscator.getWordString());
        wordClickCaptcha.setWordsCount(metadata.getWords().size());
        this.redisRepository.setExpire(identity, wordClickObfuscator.getCoordinates(), DEFAULT_EXPIRE.toMillis(), TimeUnit.MILLISECONDS);
        this.wordClickCaptcha = wordClickCaptcha;
        return this.wordClickCaptcha;
    }

    @Override
    public boolean verify(Verification verification) {
        if (ObjectUtils.isEmpty((Object)verification) || CollectionUtils.isEmpty(verification.getCoordinates())) {
            throw new CaptchaParameterIllegalException("Parameter Stamp value is null");
        }
        List store = (List)this.redisRepository.get(verification.getIdentity());
        if (CollectionUtils.isEmpty((Collection)store)) {
            throw new CaptchaHasExpiredException("Stamp is invalid!");
        }
        this.redisRepository.del(new String[]{verification.getIdentity()});
        List<Coordinate> real = verification.getCoordinates();
        for (int i = 0; i < store.size(); ++i) {
            if (!this.isDeflected(real.get(i).getX(), ((Coordinate)store.get(i)).getX(), this.getFontSize()) && !this.isDeflected(real.get(i).getX(), ((Coordinate)store.get(i)).getX(), this.getFontSize())) continue;
            throw new CaptchaMismatchException("");
        }
        return true;
    }

    @Override
    public Metadata draw() {
        BufferedImage backgroundImage = this.getResourceProvider().getRandomWordClickImage();
        int wordCount = this.getCaptchaProperties().getWordClick().getWordCount();
        List<String> words = RandomProvider.randomWords(wordCount);
        Graphics backgroundGraphics = backgroundImage.getGraphics();
        int backgroundImageWidth = backgroundImage.getWidth();
        int backgroundImageHeight = backgroundImage.getHeight();
        List<Coordinate> coordinates = IntStream.range(0, words.size()).mapToObj(index -> this.drawWord(backgroundGraphics, backgroundImageWidth, backgroundImageHeight, index, wordCount, (String)words.get(index))).collect(Collectors.toList());
        this.addWatermark(backgroundGraphics, backgroundImageWidth, backgroundImageHeight);
        BufferedImage combinedImage = new BufferedImage(backgroundImageWidth, backgroundImageHeight, 1);
        Graphics combinedGraphics = combinedImage.getGraphics();
        combinedGraphics.drawImage(backgroundImage, 0, 0, null);
        int excludeWordIndex = RandomProvider.randomInt(1, wordCount) - 1;
        words.remove(excludeWordIndex);
        coordinates.remove(excludeWordIndex);
        Metadata metadata = new Metadata();
        metadata.setWordClickImageBase64(this.toBase64(backgroundImage));
        metadata.setCoordinates(coordinates);
        metadata.setWords(words);
        return metadata;
    }

    private Coordinate drawWord(Graphics graphics, int width, int height, int index, int wordCount, String word) {
        Coordinate coordinate = this.randomWordCoordinate(width, height, index, wordCount);
        if (this.getCaptchaProperties().getWordClick().isRandomColor()) {
            graphics.setColor(new Color(RandomProvider.randomInt(1, 255), RandomProvider.randomInt(1, 255), RandomProvider.randomInt(1, 255)));
        } else {
            graphics.setColor(Color.BLACK);
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(RandomProvider.randomInt(-45, 45)), 0.0, 0.0);
        Font rotatedFont = this.getFont().deriveFont(affineTransform);
        graphics.setFont(rotatedFont);
        graphics.drawString(word, coordinate.getX(), coordinate.getY());
        return coordinate;
    }

    private int getFontSize() {
        return this.getCaptchaProperties().getWordClick().getFontSize();
    }

    private int getHalfFontSize() {
        return this.getFontSize() / 2;
    }

    private Coordinate randomWordCoordinate(int backgroundImageWidth, int backgroundImageHeight, int wordIndex, int wordCount) {
        int wordSize = this.getFontSize();
        int averageWidth = backgroundImageWidth / (wordCount + 1);
        int halfWordSize = this.getHalfFontSize();
        int x = averageWidth < halfWordSize ? RandomProvider.randomInt(this.getStartInclusive(halfWordSize), backgroundImageWidth) : (wordIndex == 0 ? RandomProvider.randomInt(this.getStartInclusive(halfWordSize), this.getEndExclusive(wordIndex, averageWidth, halfWordSize)) : RandomProvider.randomInt(averageWidth * wordIndex + halfWordSize, this.getEndExclusive(wordIndex, averageWidth, halfWordSize)));
        int y = RandomProvider.randomInt(wordSize, backgroundImageHeight - wordSize);
        return new Coordinate(x, y);
    }

    private int getStartInclusive(int halfWordSize) {
        return 1 + halfWordSize;
    }

    private int getEndExclusive(int wordIndex, int averageWidth, int halfWordSize) {
        return averageWidth * (wordIndex + 1) - halfWordSize;
    }
}

