/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.captcha.support.core.definition;

import cn.hutool.core.util.IdUtil;
import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.captcha.support.core.definition.AbstractRenderer;
import com.taotao.cloud.captcha.support.core.definition.domain.Metadata;
import com.taotao.cloud.captcha.support.core.dto.Captcha;
import com.taotao.cloud.captcha.support.core.dto.GraphicCaptcha;
import com.taotao.cloud.captcha.support.core.dto.Verification;
import com.taotao.cloud.captcha.support.core.exception.CaptchaHasExpiredException;
import com.taotao.cloud.captcha.support.core.exception.CaptchaIsEmptyException;
import com.taotao.cloud.captcha.support.core.exception.CaptchaMismatchException;
import com.taotao.cloud.captcha.support.core.exception.CaptchaParameterIllegalException;
import java.awt.Font;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGraphicRenderer
extends AbstractRenderer {
    private static final Duration DEFAULT_EXPIRE = Duration.ofMinutes(1L);
    @Autowired
    private RedisRepository redisRepository;
    private GraphicCaptcha graphicCaptcha;

    protected Font getFont() {
        return this.getResourceProvider().getGraphicFont();
    }

    protected int getWidth() {
        return this.getCaptchaProperties().getGraphics().getWidth();
    }

    protected int getHeight() {
        return this.getCaptchaProperties().getGraphics().getHeight();
    }

    protected int getLength() {
        return this.getCaptchaProperties().getGraphics().getLength();
    }

    @Override
    public Captcha getCapcha(String key) {
        String identity = key;
        if (StringUtils.isBlank((CharSequence)identity)) {
            identity = IdUtil.fastUUID();
        }
        Metadata metadata = this.draw();
        GraphicCaptcha graphicCaptcha = new GraphicCaptcha();
        graphicCaptcha.setIdentity(identity);
        graphicCaptcha.setGraphicImageBase64(metadata.getGraphicImageBase64());
        graphicCaptcha.setCategory(this.getCategory());
        this.setGraphicCaptcha(graphicCaptcha);
        this.redisRepository.setExpire(identity, (Object)metadata.getCharacters(), DEFAULT_EXPIRE.toMillis(), TimeUnit.MILLISECONDS);
        return this.getGraphicCaptcha();
    }

    @Override
    public boolean verify(Verification verification) {
        if (ObjectUtils.isEmpty((Object)verification) || StringUtils.isEmpty((CharSequence)verification.getIdentity())) {
            throw new CaptchaParameterIllegalException("Parameter value is illegal");
        }
        if (StringUtils.isEmpty((CharSequence)verification.getCharacters())) {
            throw new CaptchaIsEmptyException("Captcha is empty");
        }
        String store = (String)this.redisRepository.get(verification.getIdentity());
        if (StringUtils.isEmpty((CharSequence)store)) {
            throw new CaptchaHasExpiredException("Stamp is invalid!");
        }
        this.redisRepository.del(new String[]{verification.getIdentity()});
        String real = verification.getCharacters();
        if (!StringUtils.equalsIgnoreCase((CharSequence)store, (CharSequence)real)) {
            throw new CaptchaMismatchException("");
        }
        return true;
    }

    private GraphicCaptcha getGraphicCaptcha() {
        return this.graphicCaptcha;
    }

    protected void setGraphicCaptcha(GraphicCaptcha graphicCaptcha) {
        this.graphicCaptcha = graphicCaptcha;
    }
}

