/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.captcha.support.hutool.configuration;

import com.taotao.cloud.captcha.support.core.provider.ResourceProvider;
import com.taotao.cloud.captcha.support.hutool.renderer.CircleCaptchaRenderer;
import com.taotao.cloud.captcha.support.hutool.renderer.GifCaptchaRenderer;
import com.taotao.cloud.captcha.support.hutool.renderer.LineCaptchaRenderer;
import com.taotao.cloud.captcha.support.hutool.renderer.ShearCaptchaRenderer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class HutoolCaptchaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HutoolCaptchaConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("SDK [Engine Captcha Hutool] Auto Configure.");
    }

    @Bean(value={"HUTOOL_LINE"})
    @ConditionalOnBean(value={ResourceProvider.class})
    public LineCaptchaRenderer lineCaptchaRenderer(ResourceProvider resourceProvider) {
        LineCaptchaRenderer lineCaptchaRenderer = new LineCaptchaRenderer();
        lineCaptchaRenderer.setResourceProvider(resourceProvider);
        log.trace("Bean [Hutool Line Captcha Renderer] Auto Configure.");
        return lineCaptchaRenderer;
    }

    @Bean(value={"HUTOOL_CIRCLE"})
    @ConditionalOnBean(value={ResourceProvider.class})
    public CircleCaptchaRenderer circleCaptchaRenderer(ResourceProvider resourceProvider) {
        CircleCaptchaRenderer circleCaptchaRenderer = new CircleCaptchaRenderer();
        circleCaptchaRenderer.setResourceProvider(resourceProvider);
        log.trace(" Bean [Hutool Circle Captcha Renderer] Auto Configure.");
        return circleCaptchaRenderer;
    }

    @Bean(value={"HUTOOL_SHEAR"})
    @ConditionalOnBean(value={ResourceProvider.class})
    public ShearCaptchaRenderer shearCaptchaRenderer(ResourceProvider resourceProvider) {
        ShearCaptchaRenderer shearCaptchaRenderer = new ShearCaptchaRenderer();
        shearCaptchaRenderer.setResourceProvider(resourceProvider);
        log.trace(" Bean [Hutool Shear Captcha Renderer] Auto Configure.");
        return shearCaptchaRenderer;
    }

    @Bean(value={"HUTOOL_GIF"})
    @ConditionalOnBean(value={ResourceProvider.class})
    public GifCaptchaRenderer gifCaptchaRenderer(ResourceProvider resourceProvider) {
        GifCaptchaRenderer gifCaptchaRenderer = new GifCaptchaRenderer();
        gifCaptchaRenderer.setResourceProvider(resourceProvider);
        log.trace("Bean [Hutool Gif Captcha Renderer] Auto Configure.");
        return gifCaptchaRenderer;
    }
}

