/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.http;

import com.taotao.cloud.common.http.HttpResponse;
import com.taotao.cloud.common.http.ResponseSpec;
import com.taotao.cloud.common.http.retry.IRetry;
import java.io.IOException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RetryInterceptor
implements Interceptor {
    private final IRetry retry;
    @Nullable
    private final Predicate<ResponseSpec> respPredicate;

    public RetryInterceptor(IRetry retry, @Nullable Predicate<ResponseSpec> respPredicate) {
        this.retry = retry;
        this.respPredicate = respPredicate;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        return this.retry.execute(() -> {
            Response response = chain.proceed(request);
            if (this.respPredicate == null) {
                return response;
            }
            ResponseBody body = response.peekBody(Long.MAX_VALUE);
            try (HttpResponse httpResponse = new HttpResponse(response);){
                if (this.respPredicate.test(httpResponse)) {
                    throw new IOException("Http Retry ResponsePredicate test Failure.");
                }
            }
            return response.newBuilder().body(body).build();
        });
    }
}

