/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.http.retry;

import cn.hutool.core.thread.ThreadUtil;
import com.taotao.cloud.common.http.retry.IRetry;
import com.taotao.cloud.common.http.retry.RetryCallback;
import com.taotao.cloud.common.utils.exception.ExceptionUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.io.IOException;

public final class SimpleRetry
implements IRetry {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private static final long DEFAULT_BACK_OFF_PERIOD = 1L;
    private final int maxAttempts;
    private final long sleepMillis;

    public SimpleRetry() {
        this(3, 1L);
    }

    public SimpleRetry(int maxAttempts) {
        this(maxAttempts, 1L);
    }

    public SimpleRetry(int maxAttempts, long sleepMillis) {
        this.maxAttempts = maxAttempts;
        this.sleepMillis = sleepMillis > 0L ? sleepMillis : 1L;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    @Override
    public <T, E extends Throwable> T execute(RetryCallback<T, E> retryCallback) throws E {
        Throwable lastThrowable = null;
        for (int i = 0; i < this.maxAttempts; ++i) {
            try {
                return retryCallback.call();
            }
            catch (Throwable e) {
                int retryCount = i + 1;
                LogUtils.warn("retry on {} times error{}.", retryCount, e.getMessage());
                lastThrowable = e;
                if (this.sleepMillis <= 0L || retryCount >= this.maxAttempts) continue;
                ThreadUtil.sleep((long)this.sleepMillis);
                continue;
            }
        }
        if (lastThrowable == null) {
            lastThrowable = new IOException("retry on " + this.maxAttempts + " times,still fail.");
        }
        throw ExceptionUtils.unchecked(lastThrowable);
    }
}

