/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.loadbalancer.spi;

import com.taotao.cloud.common.loadbalancer.entity.Upstream;
import com.taotao.cloud.common.loadbalancer.spi.LoadBalancer;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractLoadBalancer
implements LoadBalancer {
    protected abstract Upstream doSelect(List<Upstream> var1, String var2);

    @Override
    public Upstream select(List<Upstream> upstreamList, String ip) {
        if (CollectionUtils.isEmpty(upstreamList)) {
            return null;
        }
        if (upstreamList.size() == 1) {
            return upstreamList.get(0);
        }
        return this.doSelect(upstreamList, ip);
    }

    protected int getWeight(Upstream upstream) {
        if (!upstream.isStatus()) {
            return 0;
        }
        return this.getWeight(upstream.getTimestamp(), upstream.getWarmup(), upstream.getWeight());
    }

    private int getWeight(long timestamp, int warmup, int weight) {
        int uptime;
        if (weight > 0 && timestamp > 0L && (uptime = (int)(System.currentTimeMillis() - timestamp)) > 0 && uptime < warmup) {
            return this.calculateWarmupWeight(uptime, warmup, weight);
        }
        return weight;
    }

    private int calculateWarmupWeight(int uptime, int warmup, int weight) {
        int ww = (int)((float)uptime / ((float)warmup / (float)weight));
        return ww < 1 ? 1 : Math.min(ww, weight);
    }
}

