/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.loadbalancer.spi;

import com.taotao.cloud.common.loadbalancer.entity.Upstream;
import com.taotao.cloud.common.loadbalancer.spi.AbstractLoadBalancer;
import com.taotao.cloud.common.spi.Join;
import java.security.SecureRandom;
import java.util.List;

@Join
public class RandomLoadBalancer
extends AbstractLoadBalancer {
    private static final SecureRandom RANDOM = new SecureRandom();

    @Override
    public Upstream doSelect(List<Upstream> upstreamList, String ip) {
        int totalWeight = this.calculateTotalWeight(upstreamList);
        boolean sameWeight = this.isAllUpStreamSameWeight(upstreamList);
        if (totalWeight > 0 && !sameWeight) {
            return this.random(totalWeight, upstreamList);
        }
        return this.random(upstreamList);
    }

    private boolean isAllUpStreamSameWeight(List<Upstream> upstreamList) {
        boolean sameWeight = true;
        int length = upstreamList.size();
        for (int i = 0; i < length; ++i) {
            int weight = this.getWeight(upstreamList.get(i));
            if (i <= 0 || weight == this.getWeight(upstreamList.get(i - 1))) continue;
            sameWeight = false;
            break;
        }
        return sameWeight;
    }

    private int calculateTotalWeight(List<Upstream> upstreamList) {
        int totalWeight = 0;
        for (Upstream upstream : upstreamList) {
            int weight = this.getWeight(upstream);
            totalWeight += weight;
        }
        return totalWeight;
    }

    private Upstream random(int totalWeight, List<Upstream> upstreamList) {
        int offset = RANDOM.nextInt(totalWeight);
        for (Upstream upstream : upstreamList) {
            if ((offset -= this.getWeight(upstream)) >= 0) continue;
            return upstream;
        }
        return upstreamList.get(0);
    }

    private Upstream random(List<Upstream> upstreamList) {
        return upstreamList.get(RANDOM.nextInt(upstreamList.size()));
    }
}

