/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model;

import java.io.Serializable;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public class Lazy<T>
implements Supplier<T>,
Serializable {
    @Nullable
    private transient Supplier<? extends T> supplier;
    @Nullable
    private T value;

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    @Nullable
    public T get() {
        return this.supplier == null ? this.value : this.computeValue();
    }

    @Nullable
    private synchronized T computeValue() {
        Supplier<T> s = this.supplier;
        if (s != null) {
            this.value = s.get();
            this.supplier = null;
        }
        return this.value;
    }
}

