/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.taotao.cloud.common.utils.lang.StringUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u5f53\u524d\u7b2c\u51e0\u9875\uff0c\u9ed8\u8ba41", example="1", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="\u5f53\u524d\u9875\u663e\u793a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a")
    @Min(value=0L, message="\u5f53\u524d\u9875\u6570\u4e0d\u80fd\u5c0f\u4e8e0")
    @Max(value=0x7FFFFFFFL)
    private @NotNull(message="\u5f53\u524d\u9875\u663e\u793a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=0L, message="\u5f53\u524d\u9875\u6570\u4e0d\u80fd\u5c0f\u4e8e0") @Max(value=0x7FFFFFFFL) Integer currentPage;
    @Schema(description="\u6bcf\u9875\u663e\u793a\u6761\u6570\uff0c\u9ed8\u8ba410", example="10", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="\u6bcf\u9875\u6570\u636e\u663e\u793a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a")
    @Min(value=5L, message="\u6bcf\u9875\u663e\u793a\u6761\u6570\u6700\u5c0f\u4e3a5\u6761")
    @Max(value=100L, message="\u6bcf\u9875\u663e\u793a\u6761\u6570\u6700\u5927\u4e3a100\u6761")
    private @NotNull(message="\u6bcf\u9875\u6570\u636e\u663e\u793a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=5L, message="\u6bcf\u9875\u663e\u793a\u6761\u6570\u6700\u5c0f\u4e3a5\u6761") @Max(value=100L, message="\u6bcf\u9875\u663e\u793a\u6761\u6570\u6700\u5927\u4e3a100\u6761") Integer pageSize;
    @Schema(description="\u6392\u5e8f\u5b57\u6bb5")
    private String sort;
    @Schema(description="\u6392\u5e8f\u65b9\u5f0f asc/desc")
    private String order;

    public <T> IPage<T> buildMpPage() {
        Page page = new Page((long)this.currentPage.intValue(), (long)this.pageSize.intValue());
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        orders.add(OrderItem.desc((String)"create_time"));
        if (StringUtils.isNotBlank(this.sort) && StringUtils.isNotBlank(this.order)) {
            OrderItem orderItem = "asc".equals(this.order) ? OrderItem.asc((String)this.sort) : OrderItem.desc((String)this.sort);
            orders.add(orderItem);
        }
        page.setOrders(orders);
        return page;
    }

    public Pageable buildJpaPage() {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(Sort.Order.desc((String)"create_time"));
        if (StringUtils.isNotBlank(this.sort) && StringUtils.isNotBlank(this.order)) {
            Sort.Order orderItem = "asc".equals(this.order) ? Sort.Order.asc((String)this.sort) : Sort.Order.desc((String)this.sort);
            orders.add(orderItem);
        }
        return PageRequest.of((int)this.currentPage, (int)this.pageSize, (Sort)Sort.by(orders));
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public PageParam getPageParm() {
        return this;
    }
}

