/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model;

import com.taotao.cloud.common.enums.EventEnum;
import com.taotao.cloud.common.model.Callable;
import com.taotao.cloud.common.model.Pubsub;
import com.taotao.cloud.common.utils.bean.BeanUtils;
import com.taotao.cloud.common.utils.common.PropertyUtils;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.CommandLineRunner;

public class PropertyCache
implements CommandLineRunner {
    private final Pubsub<HashMap<String, Object>> pubsub;
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();
    private boolean isStart = false;

    public PropertyCache(Pubsub<HashMap<String, Object>> pubsub) {
        this.pubsub = pubsub;
    }

    public void run(String ... args) throws Exception {
        this.clear();
        this.isStart = true;
    }

    public <T> T get(String key, T defaultValue) {
        if (!this.isStart) {
            String v = PropertyUtils.getProperty(key);
            if (v == null) {
                return defaultValue;
            }
            return (T)BeanUtils.convert(v, defaultValue.getClass());
        }
        Object value = this.cache.get(key);
        if (value == null) {
            String v = PropertyUtils.getProperty(key);
            if (v != null) {
                this.cache.put(key, v);
            } else {
                this.cache.put(key, PropertyUtils.NULL);
            }
        }
        if (PropertyUtils.NULL.equals(value = this.cache.get(key))) {
            return defaultValue;
        }
        return (T)BeanUtils.convert(value, defaultValue.getClass());
    }

    public void tryUpdateCache(final String key, final Object value) {
        if (!this.isStart) {
            return;
        }
        if (this.cache.containsKey(key)) {
            if (value == null) {
                this.cache.put(key, PropertyUtils.NULL);
            } else {
                this.cache.put(key, value);
            }
        }
        this.pubsub.pub(EventEnum.PropertyCacheUpdateEvent.toString(), new HashMap<String, Object>(1){
            {
                super(initialCapacity);
                this.put(key, value);
            }
        });
    }

    public void listenUpdateCache(String name, Callable.Action1<HashMap<String, Object>> action) {
        this.pubsub.sub(EventEnum.PropertyCacheUpdateEvent, new Pubsub.Sub<HashMap<String, Object>>(name, action));
    }

    public void clear() {
        this.cache.clear();
    }
}

