/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.utils.common.IdGeneratorUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.slf4j.MDC;

@Schema(description="\u8fd4\u56de\u7ed3\u679c\u5bf9\u8c61")
public class Result<T>
implements Serializable {
    @Schema(description="\u72b6\u6001\u7801")
    private int code;
    @Schema(description="\u8fd4\u56de\u6570\u636e")
    private T data;
    @Schema(description="\u662f\u5426\u6210\u529f")
    private boolean success;
    @Schema(description="\u5f02\u5e38\u6d88\u606f\u4f53")
    private String errorMsg;
    @Schema(description="\u8bf7\u6c42id")
    private String requestId;
    @Schema(description="\u8bf7\u6c42\u7ed3\u675f\u65f6\u95f4")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime timestamp;
    private static final long serialVersionUID = -3685249101751401211L;

    public static <T> Result<T> success(T data) {
        return Result.of(ResultEnum.SUCCESS.getCode(), data, true, "");
    }

    public static <T> Result<T> success(T data, int code) {
        return Result.of(code, data, true, "");
    }

    public static Result<String> success(ResultEnum resultEnum) {
        return Result.of(resultEnum.getCode(), resultEnum.getDesc(), true, "");
    }

    public static Result<String> fail() {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, ResultEnum.ERROR.getDesc());
    }

    public static <T> Result<T> fail(String errorMsg) {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> Result<T> fail(String data, int code) {
        return Result.of(code, null, false, data);
    }

    public static Result<String> fail(ResultEnum resultEnum) {
        return Result.of(resultEnum.getCode(), null, false, resultEnum.getDesc());
    }

    public static <T> Result<T> fail(Throwable throwable) {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, throwable.getMessage());
    }

    public static <T> Result<T> validFail(ResultEnum resultEnum) {
        return Result.of(resultEnum.getCode(), null, false, resultEnum.getDesc());
    }

    public static <T> Result<T> validFail(String errorMsg, Object ... args) {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> Result<T> validFail(String errorMsg) {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> Result<T> of(int code, T data, boolean success, String errorMsg) {
        return Result.builder().code(code).data(data).success(success).errorMsg(errorMsg).timestamp(LocalDateTime.now()).requestId(StrUtil.isNotBlank((CharSequence)MDC.get((String)"taotao-cloud-trace-id")) ? MDC.get((String)"taotao-cloud-trace-id") : IdGeneratorUtils.getIdStr()).build();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public static final class ResultBuilder<T> {
        private int code;
        private T data;
        private boolean success;
        private String errorMsg;
        private String requestId;
        private LocalDateTime timestamp;

        private ResultBuilder() {
        }

        public ResultBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public ResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResultBuilder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public ResultBuilder<T> errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public ResultBuilder<T> requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public ResultBuilder<T> timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Result<T> build() {
            Result<T> result = new Result<T>();
            result.setCode(this.code);
            result.setData(this.data);
            result.setSuccess(this.success);
            result.setErrorMsg(this.errorMsg);
            result.setRequestId(this.requestId);
            result.setTimestamp(this.timestamp);
            return result;
        }
    }
}

