/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUser
implements UserDetails,
CredentialsContainer,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3685249101751401211L;
    private static final String ROLE_PREFIX = "ROLE_";
    private Long userId;
    private String account;
    private String username;
    private String nickname;
    private String password;
    private String phone;
    private String mobile;
    private String email;
    private Integer sex;
    private String birthday;
    private String avatar;
    private Integer status;
    private String lockFlag;
    private String delFlag;
    private Integer type;
    private Long storeId;
    private List<String> companyIds;
    private List<String> deptIds;
    private List<String> jobIds;
    private Set<String> permissions;
    private Set<String> roleIds;
    private Set<String> roleCodes;
    private String tenant;
    private boolean superAdmin;
    private boolean admin;

    public SecurityUser() {
    }

    public SecurityUser(Long userId, String username, String password, Set<String> permissions, Set<String> roleCodes) {
        this.userId = userId;
        this.username = username;
        this.password = password;
        this.permissions = permissions;
        this.roleCodes = roleCodes;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        HashSet authorities = new HashSet();
        if (!CollUtil.isEmpty(this.roleCodes)) {
            this.roleCodes.parallelStream().forEach(role -> authorities.add(new SimpleGrantedAuthority(ROLE_PREFIX + role)));
        }
        if (!CollUtil.isEmpty(this.permissions)) {
            this.permissions.parallelStream().forEach(permission -> authorities.add(new SimpleGrantedAuthority(permission)));
        }
        return authorities;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Long getStoreId() {
        return this.storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getLockFlag() {
        return this.lockFlag;
    }

    public void setLockFlag(String lockFlag) {
        this.lockFlag = lockFlag;
    }

    public String getDelFlag() {
        return this.delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Integer getSex() {
        return this.sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public static SecurityUserBuilder builder() {
        return new SecurityUserBuilder();
    }

    public List<String> getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(List<String> companyIds) {
        this.companyIds = companyIds;
    }

    public List<String> getDeptIds() {
        return this.deptIds;
    }

    public void setDeptIds(List<String> deptIds) {
        this.deptIds = deptIds;
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public void setJobIds(List<String> jobIds) {
        this.jobIds = jobIds;
    }

    public Set<String> getRoleIds() {
        return this.roleIds;
    }

    public void setRoleIds(Set<String> roleIds) {
        this.roleIds = roleIds;
    }

    public Set<String> getRoleCodes() {
        return this.roleCodes;
    }

    public void setRoleCodes(Set<String> roleCodes) {
        this.roleCodes = roleCodes;
    }

    public boolean isSuperAdmin() {
        return this.superAdmin;
    }

    public void setSuperAdmin(boolean superAdmin) {
        this.superAdmin = superAdmin;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean getAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void eraseCredentials() {
        this.password = null;
    }

    public SecurityUser clone() {
        try {
            return (SecurityUser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public boolean getLongTerm() {
        return false;
    }

    public static final class SecurityUserBuilder {
        private String ROLE_PREFIX;
        private Long userId;
        private String account;
        private String username;
        private String nickname;
        private String password;
        private String phone;
        private String mobile;
        private String email;
        private Integer sex;
        private String birthday;
        private String avatar;
        private Integer status;
        private String lockFlag;
        private String delFlag;
        private Integer type;
        private Long storeId;
        private List<String> companyIds;
        private List<String> deptIds;
        private List<String> jobIds;
        private Set<String> permissions;
        private Set<String> roleIds;
        private Set<String> roleCodes;
        private String tenant;
        private boolean superAdmin;
        private boolean admin;

        private SecurityUserBuilder() {
        }

        public SecurityUserBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public SecurityUserBuilder account(String account) {
            this.account = account;
            return this;
        }

        public SecurityUserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SecurityUserBuilder nickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public SecurityUserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SecurityUserBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public SecurityUserBuilder mobile(String mobile) {
            this.mobile = mobile;
            return this;
        }

        public SecurityUserBuilder email(String email) {
            this.email = email;
            return this;
        }

        public SecurityUserBuilder sex(Integer sex) {
            this.sex = sex;
            return this;
        }

        public SecurityUserBuilder birthday(String birthday) {
            this.birthday = birthday;
            return this;
        }

        public SecurityUserBuilder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public SecurityUserBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public SecurityUserBuilder lockFlag(String lockFlag) {
            this.lockFlag = lockFlag;
            return this;
        }

        public SecurityUserBuilder delFlag(String delFlag) {
            this.delFlag = delFlag;
            return this;
        }

        public SecurityUserBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public SecurityUserBuilder storeId(Long storeId) {
            this.storeId = storeId;
            return this;
        }

        public SecurityUserBuilder companyIds(List<String> companyIds) {
            this.companyIds = companyIds;
            return this;
        }

        public SecurityUserBuilder deptIds(List<String> deptIds) {
            this.deptIds = deptIds;
            return this;
        }

        public SecurityUserBuilder jobIds(List<String> jobIds) {
            this.jobIds = jobIds;
            return this;
        }

        public SecurityUserBuilder permissions(Set<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public SecurityUserBuilder roleIds(Set<String> roleIds) {
            this.roleIds = roleIds;
            return this;
        }

        public SecurityUserBuilder roleCodes(Set<String> roleCodes) {
            this.roleCodes = roleCodes;
            return this;
        }

        public SecurityUserBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public SecurityUserBuilder superAdmin(boolean superAdmin) {
            this.superAdmin = superAdmin;
            return this;
        }

        public SecurityUserBuilder admin(boolean admin) {
            this.admin = admin;
            return this;
        }

        public SecurityUser build() {
            SecurityUser securityUser = new SecurityUser();
            securityUser.setUserId(this.userId);
            securityUser.setAccount(this.account);
            securityUser.setUsername(this.username);
            securityUser.setNickname(this.nickname);
            securityUser.setPassword(this.password);
            securityUser.setPhone(this.phone);
            securityUser.setMobile(this.mobile);
            securityUser.setEmail(this.email);
            securityUser.setSex(this.sex);
            securityUser.setBirthday(this.birthday);
            securityUser.setAvatar(this.avatar);
            securityUser.setStatus(this.status);
            securityUser.setLockFlag(this.lockFlag);
            securityUser.setDelFlag(this.delFlag);
            securityUser.setType(this.type);
            securityUser.setStoreId(this.storeId);
            securityUser.setCompanyIds(this.companyIds);
            securityUser.setDeptIds(this.deptIds);
            securityUser.setJobIds(this.jobIds);
            securityUser.setPermissions(this.permissions);
            securityUser.setRoleIds(this.roleIds);
            securityUser.setRoleCodes(this.roleCodes);
            securityUser.setTenant(this.tenant);
            securityUser.setSuperAdmin(this.superAdmin);
            securityUser.setAdmin(this.admin);
            return securityUser;
        }
    }
}

