/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model.clazz;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.taotao.cloud.common.utils.common.OrikaUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Page;

@Schema(description="\u5206\u9875\u7ed3\u679c\u5bf9\u8c61")
public record PageResult<R>(@Schema(description="\u603b\u6761\u6570") long totalSize, @Schema(description="\u603b\u9875\u6570") int totalPage, @Schema(description="\u5f53\u524d\u7b2c\u51e0\u9875") int currentPage, @Schema(description="\u6bcf\u9875\u663e\u793a\u6761\u6570") int pageSize, @Schema(description="\u8fd4\u56de\u6570\u636e") List<R> data) implements Serializable
{
    private static final long serialVersionUID = -275582248840137389L;

    public static <R, T> PageResult<R> convertJpaPage(Page<T> page, Class<R> rClass) {
        return PageResult.convertJpaPage(page, rClass, new HashMap<String, String>());
    }

    public static <R, T> PageResult<R> convertJpaPage(Page<T> page, Class<R> rClass, Map<String, String> configMap) {
        List records = page.getContent();
        List<Object> collect = ((List)Optional.of(records).orElse(new ArrayList())).stream().filter(Objects::nonNull).map(t -> OrikaUtils.convert(t, rClass, configMap)).toList();
        return PageResult.of(page.getTotalElements(), page.getTotalPages(), page.getNumber(), page.getSize(), collect);
    }

    public static <R, T> PageResult<R> convertMybatisPage(IPage<T> page, Class<R> rClass) {
        return PageResult.convertMybatisPage(page, rClass, new HashMap<String, String>());
    }

    public static <R, T> PageResult<R> convertMybatisPage(IPage<T> page, Class<R> rClass, Map<String, String> configMap) {
        List records = page.getRecords();
        List<Object> collect = ((List)Optional.ofNullable(records).orElse(new ArrayList())).stream().filter(Objects::nonNull).map(t -> OrikaUtils.convert(t, rClass, configMap)).toList();
        return PageResult.of(page.getTotal(), (int)page.getPages(), (int)page.getCurrent(), (int)page.getSize(), collect);
    }

    public static <R> PageResult<R> of(long totalSize, int totalPage, int currentPage, int pageSize, List<R> data) {
        return new PageResult<R>(totalSize, totalPage, currentPage, pageSize, data);
    }
}

