/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model.query.generator;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.model.query.code.ParamTypeEnum;
import com.taotao.cloud.common.model.query.entity.QueryParam;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ParamValueTypeConvert {
    public static Object initQueryParamValue(QueryParam queryParam) {
        Object paramValue = queryParam.getParamValue();
        if (Objects.isNull(paramValue)) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)queryParam.getParamType())) {
            return paramValue;
        }
        ParamTypeEnum paramTypeEnum = Optional.ofNullable(ParamTypeEnum.getByCode(queryParam.getParamType())).orElseThrow(() -> new BusinessException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b"));
        switch (paramTypeEnum) {
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                return ParamValueTypeConvert.convertType(paramValue, paramTypeEnum);
            }
            case LIST: {
                Collection collection = (Collection)paramValue;
                return collection.stream().map(o -> ParamValueTypeConvert.convertType(o, paramTypeEnum)).collect(Collectors.toList());
            }
        }
        return null;
    }

    private static Object convertType(Object paramValue, ParamTypeEnum paramTypeEnum) {
        ParamTypeEnum typeEnum = Optional.ofNullable(ParamTypeEnum.getByCode(paramTypeEnum.getCode())).orElseThrow(() -> new BusinessException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b"));
        switch (typeEnum) {
            case NUMBER: 
            case STRING: 
            case BOOLEAN: {
                return paramValue;
            }
            case DATE: {
                return LocalDateTimeUtil.parseDate((CharSequence)((String)paramValue), (String)"yyyy-MM-dd");
            }
            case TIME: {
                return LocalDateTimeUtil.parse((CharSequence)((String)paramValue), (String)"HH:mm:ss").toLocalTime();
            }
            case DATE_TIME: {
                return LocalDateTimeUtil.parse((CharSequence)((String)paramValue), (String)"yyyy-MM-dd HH:mm:ss");
            }
            case LIST: {
                return paramValue;
            }
        }
        throw new BusinessException("\u7c7b\u578b\u9519\u8bef");
    }
}

