/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.serializer;

import com.taotao.cloud.common.serializer.Serializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public enum SerializerFactory {
    SF;

    final Map<String, Serializer> serializerMap = new HashMap<String, Serializer>();

    private SerializerFactory() {
        ServiceLoader<Serializer> serializers = ServiceLoader.load(Serializer.class);
        for (Serializer serializer : serializers) {
            if (!Objects.nonNull(serializer)) continue;
            String name = serializer.name();
            if (this.serializerMap.containsKey(name)) {
                throw new RuntimeException("\u5e8f\u5217\u5316\u65b9\u5f0f\u5df2\u5b58\u5728: " + name);
            }
            this.serializerMap.put(name, serializer);
        }
    }

    public Serializer getExtension(String name) {
        return this.serializerMap.get(name);
    }
}

