/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.support.generator;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSVFileGenerator {
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final Charset charset = Charset.forName("utf-8");

    public static void generate(List<HashMap<String, Object>> data, String[] columns, String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        for (Map map : data) {
            ArrayList result = Lists.newArrayList();
            for (String column : columns) {
                if (map.get(column) != null) {
                    result.add(map.get(column).toString());
                    continue;
                }
                result.add("");
            }
            String lineData = Joiner.on((String)",").skipNulls().join((Iterable)result);
            try {
                Files.asCharSink((File)file, (Charset)charset, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)(lineData + LINE_SEPERATOR));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

