/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.support.generator.bank;

import com.taotao.cloud.common.support.generator.util.LuhnUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BankCardNumberValidator {
    public static boolean validate(String cardNo) {
        if (StringUtils.isEmpty((CharSequence)cardNo)) {
            return false;
        }
        if (!NumberUtils.isDigits((String)cardNo)) {
            return false;
        }
        if (cardNo.length() > 19 || cardNo.length() < 16) {
            return false;
        }
        int luhnSum = LuhnUtils.getLuhnSum(cardNo.substring(0, cardNo.length() - 1).trim().toCharArray());
        char checkCode = luhnSum % 10 == 0 ? (char)'0' : (char)(10 - luhnSum % 10 + 48);
        return cardNo.substring(cardNo.length() - 1).charAt(0) == checkCode;
    }
}

