/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.support.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.taotao.cloud.common.support.json.NullArrayJsonSerializer;
import com.taotao.cloud.common.support.json.NullMapJsonSerializer;
import com.taotao.cloud.common.support.json.NullPrimitiveWrapperBooleanJsonSerializer;
import com.taotao.cloud.common.support.json.NullPrimitiveWrapperNumberJsonSerializer;
import com.taotao.cloud.common.utils.reflect.ClassUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MyBeanSerializerModifier
extends BeanSerializerModifier {
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        for (BeanPropertyWriter writer : beanProperties) {
            if (this.isArrayType(writer)) {
                writer.assignNullSerializer((JsonSerializer)NullArrayJsonSerializer.INSTANCE);
                continue;
            }
            if (this.isMapType(writer)) {
                writer.assignNullSerializer((JsonSerializer)NullMapJsonSerializer.INSTANCE);
                continue;
            }
            if (this.isBooleanType(writer)) {
                writer.assignNullSerializer((JsonSerializer)NullPrimitiveWrapperBooleanJsonSerializer.INSTANCE);
                continue;
            }
            if (!this.isDoubleType(writer) && !this.isFloatType(writer) && !this.isDoubleType(writer) && !this.isIntegerType(writer) && !this.isLongType(writer) && !this.isShortType(writer)) continue;
            writer.assignNullSerializer((JsonSerializer)NullPrimitiveWrapperNumberJsonSerializer.INSTANCE);
        }
        return beanProperties;
    }

    private boolean isArrayType(BeanPropertyWriter writer) {
        Class rawClass = writer.getType().getRawClass();
        return rawClass.isArray() || Collection.class.isAssignableFrom(rawClass);
    }

    private boolean isMapType(BeanPropertyWriter writer) {
        Class rawClass = writer.getType().getRawClass();
        return Map.class.isAssignableFrom(rawClass);
    }

    private boolean isBooleanType(BeanPropertyWriter writer) {
        Class rawClass = writer.getType().getRawClass();
        return ClassUtils.isAssignable(rawClass, Boolean.class);
    }

    private boolean isDoubleType(BeanPropertyWriter writer) {
        Class rawClass = writer.getType().getRawClass();
        return ClassUtils.isAssignable(rawClass, Double.class);
    }

    private boolean isFloatType(BeanPropertyWriter writer) {
        Class rawClass = writer.getType().getRawClass();
        return ClassUtils.isAssignable(rawClass, Float.class);
    }

    private boolean isIntegerType(BeanPropertyWriter writer) {
        Class rawClass = writer.getType().getRawClass();
        return ClassUtils.isAssignable(rawClass, Integer.class);
    }

    private boolean isLongType(BeanPropertyWriter writer) {
        Class rawClass = writer.getType().getRawClass();
        return ClassUtils.isAssignable(rawClass, Long.class);
    }

    private boolean isShortType(BeanPropertyWriter writer) {
        Class rawClass = writer.getType().getRawClass();
        return ClassUtils.isAssignable(rawClass, Short.class);
    }
}

