/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.common;

import com.taotao.cloud.common.utils.common.ConvertUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;

public class CodeUtil {
    private static final int NUM_LENGTH = 2;
    public static final int ZHANWEI_LENGTH = 3;
    public static final char LETTER = 'Z';

    public static synchronized String getNextYouBianCode(String code) {
        Object newcode = "";
        if (ConvertUtils.isEmpty(code)) {
            String zimu = "A";
            String num = CodeUtil.getStrNum(1);
            newcode = zimu + num;
        } else {
            String beforeCode = code.substring(0, code.length() - 1 - 2);
            String afterCode = code.substring(code.length() - 1 - 2);
            char afterCodeZimu = afterCode.substring(0, 1).charAt(0);
            Integer afterCodeNum = Integer.parseInt(afterCode.substring(1));
            String nextNum = "";
            char nextZimu = 'A';
            nextNum = afterCodeNum == CodeUtil.getMaxNumByLength(2) ? CodeUtil.getNextStrNum(0) : CodeUtil.getNextStrNum(afterCodeNum);
            nextZimu = afterCodeNum == CodeUtil.getMaxNumByLength(2) ? (char)CodeUtil.getNextZiMu(afterCodeZimu) : (char)afterCodeZimu;
            newcode = 'Z' == afterCodeZimu && CodeUtil.getMaxNumByLength(2) == afterCodeNum ? code + nextZimu + nextNum : beforeCode + nextZimu + nextNum;
        }
        return newcode;
    }

    public static synchronized String getSubYouBianCode(String parentCode, String localCode) {
        if (localCode != null && localCode != "") {
            return CodeUtil.getNextYouBianCode(localCode);
        }
        parentCode = (String)parentCode + "A" + CodeUtil.getNextStrNum(0);
        return parentCode;
    }

    private static String getNextStrNum(int num) {
        return CodeUtil.getStrNum(CodeUtil.getNextNum(num));
    }

    private static String getStrNum(int num) {
        return String.format("%02d", num);
    }

    private static int getNextNum(int num) {
        return ++num;
    }

    private static char getNextZiMu(char zimu) {
        if (zimu == 'Z') {
            return 'A';
        }
        zimu = (char)(zimu + '\u0001');
        return zimu;
    }

    private static int getMaxNumByLength(int length) {
        if (length == 0) {
            return 0;
        }
        StringBuilder maxNum = new StringBuilder();
        maxNum.append("9".repeat(Math.max(0, length)));
        return Integer.parseInt(maxNum.toString());
    }

    public static String[] cutYouBianCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        int c = code.length() / 3;
        String[] cutcode = new String[c];
        for (int i = 0; i < c; ++i) {
            cutcode[i] = code.substring(0, (i + 1) * 3);
        }
        return cutcode;
    }
}

