/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.common;

import com.taotao.cloud.common.utils.log.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeanUtils;

public class ConvertUtils {
    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if ("".equals(object)) {
            return true;
        }
        return "null".equals(object);
    }

    public static boolean isNotEmpty(Object object) {
        return object != null && !"".equals(object) && !object.equals("null");
    }

    public static String decode(String strIn, String sourceCode, String targetCode) {
        String temp = ConvertUtils.code2code(strIn, sourceCode, targetCode);
        return temp;
    }

    public static String StrToUTF(String strIn, String sourceCode, String targetCode) {
        strIn = "";
        try {
            strIn = new String(strIn.getBytes("ISO-8859-1"), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return strIn;
    }

    private static String code2code(String strIn, String sourceCode, String targetCode) {
        String strOut = null;
        if (strIn == null || "".equals(strIn.trim())) {
            return strIn;
        }
        try {
            byte[] b = strIn.getBytes(sourceCode);
            for (int i = 0; i < b.length; ++i) {
                System.out.print(b[i] + "  ");
            }
            strOut = new String(b, targetCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return strOut;
    }

    public static int getInt(String s, int defval) {
        if (s == null || s == "") {
            return defval;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defval;
        }
    }

    public static int getInt(String s) {
        if (s == null || s == "") {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int getInt(String s, Integer df) {
        if (s == null || s == "") {
            return df;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static double getDou(Double s, double defval) {
        if (s == null) {
            return defval;
        }
        return s;
    }

    public static int getInt(Object object, int defval) {
        if (ConvertUtils.isEmpty(object)) {
            return defval;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException e) {
            return defval;
        }
    }

    public static Integer getInt(Object object) {
        if (ConvertUtils.isEmpty(object)) {
            return null;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int getInt(BigDecimal s, int defval) {
        if (s == null) {
            return defval;
        }
        return s.intValue();
    }

    public static String getString(String s) {
        return ConvertUtils.getString(s, "");
    }

    public static String getString(Object object) {
        if (ConvertUtils.isEmpty(object)) {
            return "";
        }
        return object.toString().trim();
    }

    public static String getString(int i) {
        return String.valueOf(i);
    }

    public static String getString(float i) {
        return String.valueOf(i);
    }

    public static String getString(String s, String defval) {
        if (ConvertUtils.isEmpty(s)) {
            return defval;
        }
        return s.trim();
    }

    public static String getString(Object s, String defval) {
        if (ConvertUtils.isEmpty(s)) {
            return defval;
        }
        return s.toString().trim();
    }

    public static String getIp() {
        String ip = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            ip = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return ip;
    }

    private static boolean isBaseDataType(Class clazz) throws Exception {
        return clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(BigInteger.class) || clazz.equals(Boolean.class) || clazz.equals(Date.class) || clazz.isPrimitive();
    }

    public static String getIpAddrByRequest(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getRealIp() throws SocketException {
        String localip = null;
        String netip = null;
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress ip = null;
        boolean finded = false;
        block0: while (netInterfaces.hasMoreElements() && !finded) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                ip = address.nextElement();
                if (!(ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":"))) {
                    netip = ip.getHostAddress();
                    finded = true;
                    continue block0;
                }
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                localip = ip.getHostAddress();
            }
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            String reg = "\\s*|\t|\r|\n";
            Pattern p = Pattern.compile(reg);
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isIn(String substring, String[] source) {
        if (source == null || source.length == 0) {
            return false;
        }
        for (int i = 0; i < source.length; ++i) {
            String aSource = source[i];
            if (!aSource.equals(substring)) continue;
            return true;
        }
        return false;
    }

    public static Map<Object, Object> getHashMap() {
        return new HashMap<Object, Object>(5);
    }

    public static Map<Object, Object> setToMap(Set<Object> setobj) {
        Map<Object, Object> map = ConvertUtils.getHashMap();
        for (Map.Entry entry : setobj) {
            map.put(entry.getKey().toString(), entry.getValue() == null ? "" : entry.getValue().toString().trim());
        }
        return map;
    }

    public static boolean isInnerIp(String ipAddress) {
        boolean isInnerIp = false;
        long ipNum = ConvertUtils.getIpNum(ipAddress);
        long aBegin = ConvertUtils.getIpNum("10.0.0.0");
        long aEnd = ConvertUtils.getIpNum("10.255.255.255");
        long bBegin = ConvertUtils.getIpNum("172.16.0.0");
        long bEnd = ConvertUtils.getIpNum("172.31.255.255");
        long cBegin = ConvertUtils.getIpNum("192.168.0.0");
        long cEnd = ConvertUtils.getIpNum("192.168.255.255");
        String localIp = "127.0.0.1";
        isInnerIp = ConvertUtils.isInner(ipNum, aBegin, aEnd) || ConvertUtils.isInner(ipNum, bBegin, bEnd) || ConvertUtils.isInner(ipNum, cBegin, cEnd) || localIp.equals(ipAddress);
        return isInnerIp;
    }

    private static long getIpNum(String ipAddress) {
        String[] ip = ipAddress.split("\\.");
        long a = Integer.parseInt(ip[0]);
        long b = Integer.parseInt(ip[1]);
        long c = Integer.parseInt(ip[2]);
        long d = Integer.parseInt(ip[3]);
        long ipNum = a * 256L * 256L * 256L + b * 256L * 256L + c * 256L + d;
        return ipNum;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }

    public static String camelName(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toLowerCase() + name.substring(1).toLowerCase();
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            if (result.length() == 0) {
                result.append(camel.toLowerCase());
                continue;
            }
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String camelNames(String names) {
        String[] fs;
        if (names == null || "".equals(names)) {
            return null;
        }
        StringBuffer sf = new StringBuffer();
        for (String field : fs = names.split(",")) {
            field = ConvertUtils.camelName(field);
            sf.append(field + ",");
        }
        String result = sf.toString();
        return result.substring(0, result.length() - 1);
    }

    public static String camelNameCapFirst(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String camelToUnderline(String para) {
        int length = 3;
        if (para.length() < length) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 2; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    public static String randomGen(int place) {
        String base = "qwertyuioplkjhgfdsazxcvbnmQAZWSXEDCRFVTGBYHNUJMIKLOP0123456789";
        StringBuffer sb = new StringBuffer();
        Random rd = new Random();
        for (int i = 0; i < place; ++i) {
            sb.append(base.charAt(rd.nextInt(base.length())));
        }
        return sb.toString();
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public static List<Map<String, Object>> toLowerCasePageList(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> select = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : list) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
            Set<String> keySet = row.keySet();
            for (String key : keySet) {
                String newKey = key.toLowerCase();
                resultMap.put(newKey, row.get(key));
            }
            select.add(resultMap);
        }
        return select;
    }

    public static <F, T> List<T> entityListToModelList(List<F> fromList, Class<T> tClass) {
        if (fromList == null || fromList.isEmpty()) {
            return null;
        }
        ArrayList<T> tList = new ArrayList<T>();
        for (F f : fromList) {
            T t = ConvertUtils.entityToModel(f, tClass);
            tList.add(t);
        }
        return tList;
    }

    public static <F, T> T entityToModel(F entity, Class<T> modelClass) {
        LogUtils.debug("entityToModel : Entity\u5c5e\u6027\u7684\u503c\u8d4b\u503c\u5230Model", new Object[0]);
        T model = null;
        if (entity == null || modelClass == null) {
            return null;
        }
        try {
            model = modelClass.newInstance();
        }
        catch (InstantiationException e) {
            LogUtils.error("entityToModel : \u5b9e\u4f8b\u5316\u5f02\u5e38", e);
        }
        catch (IllegalAccessException e) {
            LogUtils.error("entityToModel : \u5b89\u5168\u6743\u9650\u5f02\u5e38", e);
        }
        BeanUtils.copyProperties(entity, model);
        return model;
    }

    public static boolean listIsEmpty(Collection list) {
        return list == null || list.size() == 0;
    }

    public static boolean listIsNotEmpty(Collection list) {
        return !ConvertUtils.listIsEmpty(list);
    }

    public static String readStatic(String url) {
        String json = "";
        try {
            InputStream stream = ConvertUtils.class.getClassLoader().getResourceAsStream(url.replace("classpath:", ""));
            json = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        }
        catch (IOException e) {
            LogUtils.error(e.getMessage(), e);
        }
        return json;
    }
}

