/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.common;

import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.enums.UserEnum;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.utils.common.SecurityUtils;
import com.taotao.cloud.common.utils.reflect.ReflectionUtils;
import java.util.Objects;

public final class OperationalJudgment {
    public static <T> T judgment(T object) {
        return OperationalJudgment.judgment(object, "memberId", "storeId");
    }

    public static <T> T judgment(T object, String buyerIdField, String storeIdField) {
        Integer type = SecurityUtils.getCurrentUser().getType();
        UserEnum userEnum = UserEnum.getEnumByCode(type);
        switch (Objects.requireNonNull(userEnum)) {
            case MANAGER: {
                return object;
            }
            case MEMBER: {
                if (SecurityUtils.getCurrentUser().getUserId().equals(ReflectionUtils.getFieldValue(object, buyerIdField))) {
                    return object;
                }
                throw new BusinessException(ResultEnum.USER_AUTHORITY_ERROR);
            }
            case STORE: {
                if (SecurityUtils.getCurrentUser().getStoreId().equals(ReflectionUtils.getFieldValue(object, storeIdField))) {
                    return object;
                }
                throw new BusinessException(ResultEnum.USER_AUTHORITY_ERROR);
            }
        }
        throw new BusinessException(ResultEnum.USER_AUTHORITY_ERROR);
    }
}

