/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.common;

import com.taotao.cloud.common.model.Callable;
import com.taotao.cloud.common.model.PropertyCache;
import com.taotao.cloud.common.utils.bean.BeanUtils;
import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.util.Map;
import java.util.Objects;

public final class PropertyUtils {
    public static String NULL = "<?NULL?>";

    public static void eachProperty(Callable.Action3<String, String, Object> call) {
        for (String string : System.getProperties().stringPropertyNames()) {
            call.invoke("properties", string, System.getProperty(string));
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            call.invoke("env", (String)entry.getKey(), entry.getValue());
        }
    }

    public static <T> T getProperty(String key, T defaultvalue) {
        String value = System.getProperty(key);
        if (value == null) {
            value = System.getenv(key);
        }
        if (value == null && ContextUtils.getApplicationContext() != null) {
            value = ContextUtils.getApplicationContext().getEnvironment().getProperty(key);
        }
        if (value == null) {
            return defaultvalue;
        }
        return (T)BeanUtils.convert(value, defaultvalue.getClass());
    }

    public static String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = System.getenv(key);
        }
        if (value == null && ContextUtils.getApplicationContext() != null) {
            value = ContextUtils.getApplicationContext().getEnvironment().getProperty(key);
        }
        return value;
    }

    public static <T> T getEnvProperty(String key, T defaultvalue) {
        String value = System.getenv(key);
        if (value == null) {
            return defaultvalue;
        }
        return (T)BeanUtils.convert(value, defaultvalue.getClass());
    }

    public static <T> T getSystemProperty(String key, T defaultvalue) {
        String value = System.getProperty(key);
        if (value == null) {
            return defaultvalue;
        }
        return (T)BeanUtils.convert(value, defaultvalue.getClass());
    }

    public static void setDefaultInitProperty(Class<?> cls, String module, String key, String propertyValue) {
        PropertyUtils.setDefaultInitProperty(cls, module, key, propertyValue, "");
    }

    public static void setDefaultInitProperty(Class<?> cls, String module, String key, String propertyValue, String message) {
        if (StringUtils.isEmpty(PropertyUtils.getPropertyCache(key, ""))) {
            if (!StringUtils.isEmpty(propertyValue)) {
                System.setProperty(key, propertyValue);
                PropertyCache propertyCache = ContextUtils.getBean(PropertyCache.class, false);
                if (Objects.nonNull(propertyCache)) {
                    propertyCache.tryUpdateCache(key, propertyValue);
                }
                LogUtils.info(" set default init property key: {}, value: {}, message: {}", key, propertyValue, message);
            }
        } else if (StringUtils.isEmpty(PropertyUtils.getSystemProperty(key, ""))) {
            System.setProperty(key, Objects.requireNonNull(PropertyUtils.getPropertyCache(key, "")));
        }
    }

    public static void setProperty(String key, String propertyValue, String message) {
        System.setProperty(key, propertyValue);
        LogUtils.info(" set default init property key: {}, value: {}, message: {}", key, propertyValue, message);
    }

    public static <T> T getPropertyCache(String key, T defaultvalue) {
        PropertyCache propertyCache = ContextUtils.getBean(PropertyCache.class, false);
        if (Objects.nonNull(propertyCache)) {
            return propertyCache.get(key, defaultvalue);
        }
        return null;
    }
}

