/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.common;

import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.model.SecurityUser;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.common.utils.context.ContextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public final class SecurityUtils {
    private static final String BASIC_ = "Basic ";

    private SecurityUtils() {
    }

    public static void writeResponse(Result<?> result, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        PrintWriter printWriter = response.getWriter();
        printWriter.write(JsonUtils.toJSONString(result));
        printWriter.flush();
    }

    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static void reloadAuthority(SecurityUser newHerodotusUser) {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)newHerodotusUser, (Object)newHerodotusUser.getPassword(), newHerodotusUser.getAuthorities());
        token.setDetails(SecurityUtils.getDetails());
        SecurityUtils.getSecurityContext().setAuthentication((Authentication)token);
    }

    public static Object getDetails() {
        return SecurityUtils.getAuthentication().getDetails();
    }

    public static SecurityContext getSecurityContext() {
        return SecurityContextHolder.getContext();
    }

    public static SecurityUser getUser(Authentication authentication) {
        if (Objects.isNull(authentication)) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (Objects.isNull(principal)) {
            return null;
        }
        if (principal instanceof SecurityUser) {
            return (SecurityUser)principal;
        }
        if (principal instanceof Map) {
            return JsonUtils.toObject(JsonUtils.toJSONString(principal), SecurityUser.class);
        }
        return null;
    }

    public static SecurityUser getCurrentUser() {
        SecurityUser securityUser = SecurityUtils.getUser(SecurityUtils.getAuthentication());
        if (Objects.isNull(securityUser)) {
            throw new BusinessException(ResultEnum.USER_NOT_LOGIN);
        }
        return securityUser;
    }

    public static SecurityUser getCurrentUserWithNull() {
        Authentication authentication = SecurityUtils.getAuthentication();
        return SecurityUtils.getUser(authentication);
    }

    public static String getUsername() {
        return SecurityUtils.getCurrentUser().getUsername();
    }

    public static String getUsernameWithAnonymous() {
        return SecurityUtils.getCurrentUserWithNull() == null ? "anonymous" : SecurityUtils.getCurrentUserWithNull().getUsername();
    }

    public static Long getUserIdWithAnonymous() {
        return SecurityUtils.getCurrentUserWithNull() == null ? -1L : SecurityUtils.getCurrentUserWithNull().getUserId();
    }

    public static Long getUserId() {
        return SecurityUtils.getCurrentUser().getUserId();
    }

    public static boolean validatePass(String newPass, String passwordEncoderOldPass) {
        return SecurityUtils.getPasswordEncoder().matches((CharSequence)newPass, passwordEncoderOldPass);
    }

    public static BCryptPasswordEncoder getPasswordEncoder() {
        BCryptPasswordEncoder passwordEncoder = ContextUtils.getBean(BCryptPasswordEncoder.class, true);
        if (Objects.isNull(passwordEncoder)) {
            passwordEncoder = new BCryptPasswordEncoder();
        }
        return passwordEncoder;
    }

    public static String[] extractHeaderClient(String header) {
        byte[] base64Client = header.substring(BASIC_.length()).getBytes(StandardCharsets.UTF_8);
        byte[] decoded = Base64.getDecoder().decode(base64Client);
        String clientStr = new String(decoded, StandardCharsets.UTF_8);
        String[] clientArr = clientStr.split(":");
        if (clientArr.length != 2) {
            throw new RuntimeException("Invalid basic authentication token");
        }
        return clientArr;
    }

    public static String getUsername(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        String username = null;
        if (principal instanceof SecurityUser) {
            username = ((SecurityUser)principal).getUsername();
        } else if (principal instanceof String) {
            username = (String)principal;
        }
        return username;
    }

    public static String getTenant() {
        return "";
    }

    public static String getClientId() {
        return "";
    }
}

