/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.context;

import cn.hutool.extra.spring.SpringUtil;
import com.taotao.cloud.common.exception.BaseException;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public class ContextUtils
extends SpringUtil {
    public static Class<?> mainClass;
    public static ConfigurableApplicationContext applicationContext;

    private ContextUtils() {
    }

    public static void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        if (Objects.nonNull(applicationContext)) {
            ContextUtils.applicationContext = applicationContext;
        }
    }

    public static ConfigurableApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static boolean isWeb() {
        return ContextUtils.getConfigurableWebServerApplicationContext() != null;
    }

    public static ConfigurableWebServerApplicationContext getConfigurableWebServerApplicationContext() {
        ConfigurableApplicationContext context = ContextUtils.getApplicationContext();
        if (context instanceof ConfigurableWebServerApplicationContext) {
            return (ConfigurableWebServerApplicationContext)context;
        }
        return null;
    }

    public static <T> T getBean(Class<T> type, boolean required) {
        block6: {
            try {
                if (type == null || applicationContext == null) break block6;
                try {
                    if (required) {
                        return (T)applicationContext.getBean(type);
                    }
                    if (applicationContext.getBeansOfType(type).size() > 0) {
                        return (T)applicationContext.getBean(type);
                    }
                }
                catch (NoSuchBeanDefinitionException e) {
                    return null;
                }
            }
            catch (BeansException e) {
                LogUtils.error(e);
            }
        }
        return null;
    }

    public static <T> T getBean(Class<T> type, String name, boolean required) {
        try {
            if (type != null && applicationContext != null) {
                if (required) {
                    return (T)applicationContext.getBean(name, type);
                }
                if (applicationContext.getBeansOfType(type).size() > 0) {
                    return (T)applicationContext.getBean(name, type);
                }
            }
        }
        catch (BeansException e) {
            LogUtils.error(e);
        }
        return null;
    }

    public static Object getBean(String type, boolean required) {
        try {
            if (type != null && applicationContext != null) {
                if (required) {
                    return applicationContext.getBean(type);
                }
                if (applicationContext.containsBean(type)) {
                    return applicationContext.getBean(type);
                }
            }
        }
        catch (BeansException e) {
            LogUtils.error(e);
        }
        return null;
    }

    public static String getBeanDefinitionText() {
        StringBuilder sb = new StringBuilder();
        try {
            Object[] beans = applicationContext.getBeanDefinitionNames();
            Arrays.sort(beans);
            sb = new StringBuilder();
            for (Object bean : beans) {
                sb.append((String)bean).append(" -> ").append(applicationContext.getBean((String)bean).getClass());
            }
        }
        catch (BeansException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> anno) {
        Map map;
        try {
            map = applicationContext.getBeansWithAnnotation(anno);
        }
        catch (Exception e) {
            map = null;
        }
        return map;
    }

    public static <T> List<T> getBeansOfTypeWithList(Class<T> clazz) {
        Map map;
        try {
            map = applicationContext.getBeansOfType(clazz);
        }
        catch (Exception e) {
            map = null;
        }
        return map == null ? null : new ArrayList(map.values());
    }

    public static void registerBean(String name, Class<?> clazz, Object ... args) {
        ContextUtils.checkRegisterBean((ApplicationContext)applicationContext, name, clazz);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        for (Object arg : args) {
            beanDefinitionBuilder.addConstructorArgValue(arg);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
    }

    public static void registerBean(String name, Class clazz, BeanDefinitionBuilder beanDefinitionBuilder) {
        ContextUtils.checkRegisterBean((ApplicationContext)applicationContext, name, clazz);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
    }

    public static void registerSingletonBean(String name, Object obj) {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        defaultListableBeanFactory.registerSingleton(name, obj);
    }

    public static void destroySingletonBean(String name) {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        defaultListableBeanFactory.destroySingleton(name);
    }

    public static void unRegisterBean(String name) {
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.removeBeanDefinition(name);
    }

    public static void checkRegisterBean(ApplicationContext applicationContext, String name, Class clazz) {
        Object bean;
        if (applicationContext.containsBean(name) && !(bean = applicationContext.getBean(name)).getClass().isAssignableFrom(clazz)) {
            throw new BaseException("BeanName \u91cd\u590d\u6ce8\u518c" + name);
        }
    }

    public static ConversionService getTypeConverter() {
        return DefaultConversionService.getSharedInstance();
    }
}

