/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.convert;

import com.taotao.cloud.common.utils.convert.ConversionService;
import com.taotao.cloud.common.utils.reflect.ClassUtils;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.lang.Nullable;

public class ConvertUtils {
    @Nullable
    public static <T> T convert(@Nullable Object source, Class<T> targetType) {
        if (source == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(targetType, (Object)source)) {
            return (T)source;
        }
        GenericConversionService conversionService = ConversionService.getInstance();
        return (T)conversionService.convert(source, targetType);
    }

    @Nullable
    public static <T> T convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        GenericConversionService conversionService = ConversionService.getInstance();
        return (T)conversionService.convert(source, sourceType, targetType);
    }

    @Nullable
    public static <T> T convert(@Nullable Object source, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        GenericConversionService conversionService = ConversionService.getInstance();
        return (T)conversionService.convert(source, targetType);
    }
}

