/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class LocalDateTimeUtil
extends cn.hutool.core.date.LocalDateTimeUtil {
    public boolean between(LocalDateTime now, LocalDateTime start, LocalDateTime end) {
        return this.ge(now, start) && this.le(now, end);
    }

    public boolean gt(LocalDateTime now, LocalDateTime next) {
        long epochMilli;
        long mills = now.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return mills > (epochMilli = next.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public boolean lt(LocalDateTime now, LocalDateTime next) {
        long epochMilli;
        long mills = now.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return mills < (epochMilli = next.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public boolean ge(LocalDateTime now, LocalDateTime next) {
        long epochMilli;
        long mills = now.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return mills >= (epochMilli = next.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public boolean le(LocalDateTime now, LocalDateTime next) {
        long epochMilli;
        long mills = now.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return mills <= (epochMilli = next.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public LocalDateTime date2DateTime(LocalDate localDate) {
        return localDate.atTime(0, 0);
    }

    public LocalDateTime parse(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public long timestamp(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return instant.toEpochMilli();
    }
}

