/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.exception;

import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.exception.BaseException;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.utils.exception.FastStringPrintWriter;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.function.Supplier;

public class ExceptionUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String trace2String(Throwable t) {
        if (t == null) {
            return "";
        }
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            try {
                t.printStackTrace(pw);
                String string = sw.getBuffer().toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exp) {
            throw new BaseException(ResultEnum.ERROR, (Throwable)exp);
        }
    }

    public static String trace2String(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement stackTraceElemen : stackTraceElements) {
            sb.append(stackTraceElemen.toString()).append("\n");
        }
        return sb.toString();
    }

    private static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getFullMessage(Throwable e) {
        if (e == null) {
            return "";
        }
        return "\u3010\u8be6\u7ec6\u9519\u8bef\u3011" + ExceptionUtils.lineSeparator() + ExceptionUtils.getDetailMessage(e) + ExceptionUtils.lineSeparator() + "\u3010\u5806\u6808\u6253\u5370\u3011" + ExceptionUtils.lineSeparator() + ExceptionUtils.getFullStackTrace(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFullStackTrace(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException iOException) {}
            }
            if (pw != null) {
                pw.close();
            }
        }
        return sw.toString();
    }

    public static String getDetailMessage(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (ex != null) {
            sb.append("\u3010" + ex.getClass().getName() + "\u3011\u2192" + StringUtils.nullToEmpty((CharSequence)ex.getMessage()) + ExceptionUtils.lineSeparator());
            ex = ex.getCause();
        }
        return sb.toString();
    }

    public static void ignoreException(Runnable runnable, boolean isPrintInfo) {
        block2: {
            try {
                runnable.run();
            }
            catch (Exception e) {
                if (isPrintInfo) break block2;
                LogUtils.error(ExceptionUtils.getFullStackTrace(e), new Object[0]);
            }
        }
    }

    public static void ignoreException(Runnable runnable) {
        ExceptionUtils.ignoreException(runnable, false);
    }

    public static <T extends BaseException> Supplier<T> unchecked(Class<T> clazz, String msg) {
        try {
            BaseException t = (BaseException)clazz.getDeclaredConstructor(String.class).newInstance(msg);
            return () -> t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Supplier<BusinessException> businessException(String msg) {
        return () -> new BusinessException(msg);
    }

    public static Supplier<BusinessException> notFound() {
        return () -> new BusinessException(ResultEnum.NOT_FOUND);
    }

    public static BusinessException notFoundException() {
        return new BusinessException(ResultEnum.NOT_FOUND);
    }

    public static RuntimeException unchecked(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return (RuntimeException)ExceptionUtils.runtime(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return (RuntimeException)ExceptionUtils.runtime(e);
    }

    private static <T extends Throwable> T runtime(Throwable throwable) throws T {
        throw throwable;
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static String getStackTraceAsString(Throwable ex) {
        FastStringPrintWriter printWriter = new FastStringPrintWriter(512);
        ex.printStackTrace(printWriter);
        return printWriter.toString();
    }

    public static Throwable unwrapThrowable(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException();
    }

    public static String getErrorMessageWithNestedException(Throwable ex) {
        Throwable nestedException = ex.getCause();
        return ex.getMessage() + " nested exception is " + nestedException.getClass().getName() + ":" + nestedException.getMessage();
    }

    public static Throwable getRootCause(Throwable ex) {
        Throwable cause;
        Throwable result = null;
        while ((cause = ex.getCause()) != null) {
            result = cause;
        }
        return result;
    }

    public static boolean isCausedBy(Exception ex, Class<? extends Exception> ... causeExceptionClasses) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }

    public static Throwable getActualThrowable(Throwable throwable) {
        if (InvocationTargetException.class.equals(throwable.getClass())) {
            InvocationTargetException exception = (InvocationTargetException)throwable;
            return exception.getTargetException();
        }
        return throwable;
    }
}

