/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.number;

import com.taotao.cloud.common.utils.lang.ObjectUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;

public class NumberUtils
extends org.springframework.util.NumberUtils {
    public static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final String[] hanArr = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] unitArr = new String[]{"\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767d", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343"};

    private NumberUtils() {
    }

    public static int toInt(String str) {
        return ObjectUtils.toInt(str, 0);
    }

    public static int toInt(@Nullable String str, int defaultValue) {
        return ObjectUtils.toInt(str, defaultValue);
    }

    public static long toLong(String str) {
        return ObjectUtils.toLong(str, 0L);
    }

    public static long toLong(@Nullable String str, long defaultValue) {
        return ObjectUtils.toLong(str, defaultValue);
    }

    public static String to62Str(long i) {
        int radix = DIGITS.length;
        byte[] buf = new byte[65];
        int charPos = 64;
        for (i = -i; i <= (long)(-radix); i /= (long)radix) {
            buf[charPos--] = DIGITS[(int)(-(i % (long)radix))];
        }
        buf[charPos] = DIGITS[(int)(-i)];
        return new String(buf, charPos, 65 - charPos, StandardCharsets.UTF_8);
    }

    public static double scale(Number number, int scale) {
        if (Objects.nonNull(number)) {
            try {
                BigDecimal bg = BigDecimal.valueOf(number.doubleValue());
                return bg.setScale(scale, RoundingMode.HALF_UP).doubleValue();
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static int stoi(String string) {
        return NumberUtils.stoi(string, 0);
    }

    public static int stoi(String string, int defaultValue) {
        int id;
        if (string == null || string.equalsIgnoreCase("") || string.equals("null")) {
            return defaultValue;
        }
        try {
            id = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
        return id;
    }

    public static long stol(String string) {
        return NumberUtils.stol(string, 0L);
    }

    public static long stol(String string, long defaultValue) {
        long ret;
        if (string == null || string.equalsIgnoreCase("")) {
            return defaultValue;
        }
        try {
            ret = Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
        return ret;
    }

    public static double stod(String string) {
        return NumberUtils.stod(string, 0.0);
    }

    public static double stod(String string, double defaultValue) {
        double ret;
        if (string == null || string.equalsIgnoreCase("")) {
            return defaultValue;
        }
        try {
            ret = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
        return ret;
    }

    public static String toChineseNum(int number) {
        String numStr = String.valueOf(number);
        StringBuilder result = new StringBuilder();
        int numLen = numStr.length();
        for (int i = 0; i < numLen; ++i) {
            int num = numStr.charAt(i) - 48;
            if (i != numLen - 1 && num != 0) {
                result.append(hanArr[num]).append(unitArr[numLen - 2 - i]);
                if (number < 10 || number >= 20) continue;
                result = new StringBuilder(result.substring(1));
                continue;
            }
            if (number >= 10 && number % 10 == 0) continue;
            result.append(hanArr[num]);
        }
        return result.toString();
    }

    public static int random(int min, int max) {
        return new Random().nextInt(max - min) + min;
    }

    public static int compare(BigDecimal flowPrice, BigDecimal actualRefundPrice) {
        return flowPrice.compareTo(actualRefundPrice);
    }
}

