/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.system;

import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.utils.lang.ObjectUtils;
import java.util.Objects;
import org.springframework.lang.Nullable;

public final class SystemUtils {
    private static final String OS_NAME_LINUX = "LINUX";
    @Nullable
    public static final String USER_HOME = SystemUtils.getSystemProperty("user.home");
    @Nullable
    public static final String USER_DIR = SystemUtils.getSystemProperty("user.dir");
    @Nullable
    public static final String USER_NAME = SystemUtils.getSystemProperty("user.name");
    @Nullable
    public static final String OS_NAME = SystemUtils.getSystemProperty("os.name");

    private SystemUtils() {
    }

    public static String getLineSeparator() {
        return SystemUtils.getProperty("line.separator");
    }

    public static String getProperty(String key) {
        return System.getProperty(key);
    }

    @Nullable
    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static boolean isLinux() {
        return StrUtil.isNotBlank((CharSequence)OS_NAME) && OS_NAME_LINUX.equalsIgnoreCase(OS_NAME);
    }

    public static boolean isLocalDev() {
        return !SystemUtils.isLinux();
    }

    @Nullable
    public static String getProp(String key) {
        return System.getProperty(key);
    }

    public static String getProp(String key, String defValue) {
        return System.getProperty(key, defValue);
    }

    public static int getPropToInt(String key, int defaultValue) {
        return ObjectUtils.toInt(SystemUtils.getProp(key), defaultValue);
    }

    public static boolean getPropToBool(String key, boolean defaultValue) {
        return Objects.requireNonNull(ObjectUtils.toBoolean(SystemUtils.getProp(key), defaultValue));
    }

    @Nullable
    public static String getPropOrEnv(String key) {
        String value = System.getProperty(key);
        return value == null ? System.getenv(key) : value;
    }
}

