/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.validator;

import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.enums.ValidatorExceptionEnum;
import com.taotao.cloud.common.exception.ParamValidateException;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidatorUtils {
    private static final Validator VALIDATOR_INSTANCE = Validation.buildDefaultValidatorFactory().getValidator();

    public static Set<ConstraintViolation<Object>> validate(Object object, Class<?> ... groups) {
        return VALIDATOR_INSTANCE.validate(object, (Class[])groups);
    }

    public static boolean simpleValidate(Object object, Class<?> ... groups) {
        Set constraintViolations = VALIDATOR_INSTANCE.validate(object, (Class[])groups);
        return constraintViolations.isEmpty();
    }

    public static void validateThrowMessage(Object object, Class<?> ... groups) {
        String errorMessage = ValidatorUtils.validateGetMessage(object, groups);
        if (errorMessage != null) {
            throw new ParamValidateException(ValidatorExceptionEnum.VALIDATED_RESULT_ERROR.getDesc());
        }
    }

    public static String validateGetMessage(Object object, Class<?> ... groups) {
        Set constraintViolations = VALIDATOR_INSTANCE.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            Iterator it = constraintViolations.iterator();
            while (it.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)it.next();
                errorMessage.append(violation.getMessage());
                if (!it.hasNext()) continue;
                errorMessage.append(", ");
            }
            return StrUtil.format((CharSequence)ValidatorExceptionEnum.VALIDATED_RESULT_ERROR.getUserTip(), (Object[])new Object[0]);
        }
        return null;
    }
}

