/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.crypto.ext.enhance;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.crypto.ext.annotation.Crypto;
import com.taotao.cloud.crypto.ext.processor.HttpCryptoProcessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@RestControllerAdvice
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestBodyAdvice.class);
    private HttpCryptoProcessor httpCryptoProcessor;

    public void setInterfaceCryptoProcessor(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        String methodName = methodParameter.getMethod().getName();
        Crypto crypto = (Crypto)methodParameter.getMethodAnnotation(Crypto.class);
        boolean isSupports = ObjectUtils.isNotEmpty((Object)crypto) && crypto.requestDecrypt();
        log.trace("Is DecryptRequestBodyAdvice supports method [{}] ? Status is [{}].", (Object)methodName, (Object)isSupports);
        return isSupports;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        String sessionKey = (String)httpInputMessage.getHeaders().get((Object)"session-key").get(0);
        if (StringUtils.isBlank((CharSequence)sessionKey)) {
            log.warn("Cannot find Herodotus Cloud custom session header. Use interface crypto founction need add X_HERODOTUS_SESSION to request header.");
            return httpInputMessage;
        }
        log.info("DecryptRequestBodyAdvice begin decrypt data.");
        String methodName = methodParameter.getMethod().getName();
        String className = methodParameter.getDeclaringClass().getName();
        String content = IoUtil.read((InputStream)httpInputMessage.getBody()).toString();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            String data = this.httpCryptoProcessor.decrypt(sessionKey, content);
            if (StringUtils.equals((CharSequence)data, (CharSequence)content)) {
                data = this.decrypt(sessionKey, content);
            }
            log.debug("Decrypt request body for rest method [{}] in [{}] finished.", (Object)methodName, (Object)className);
            return new DecryptHttpInputMessage(httpInputMessage, StrUtil.utf8Bytes((CharSequence)data));
        }
        return httpInputMessage;
    }

    private String decrypt(String sessionKey, String content) {
        JsonNode jsonNode = JsonUtils.parse((String)content);
        if (ObjectUtils.isNotEmpty((Object)jsonNode)) {
            this.decrypt(sessionKey, jsonNode);
            return JsonUtils.toJson((Object)jsonNode);
        }
        return content;
    }

    private void decrypt(String sessionKey, JsonNode jsonNode) {
        if (jsonNode.isObject()) {
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (entry.getValue() instanceof TextNode && ((JsonNode)entry.getValue()).isValueNode()) {
                    TextNode t = (TextNode)entry.getValue();
                    String value = this.httpCryptoProcessor.decrypt(sessionKey, t.asText());
                    entry.setValue(new TextNode(value));
                }
                this.decrypt(sessionKey, (JsonNode)entry.getValue());
            }
        }
        if (jsonNode.isArray()) {
            for (JsonNode node : jsonNode) {
                this.decrypt(sessionKey, node);
            }
        }
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public static class DecryptHttpInputMessage
    implements HttpInputMessage {
        private final HttpInputMessage httpInputMessage;
        private final byte[] data;

        public DecryptHttpInputMessage(HttpInputMessage httpInputMessage, byte[] data) {
            this.httpInputMessage = httpInputMessage;
            this.data = data;
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public HttpHeaders getHeaders() {
            return this.httpInputMessage.getHeaders();
        }
    }
}

