/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.crypto.ext.enhance;

import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.crypto.ext.annotation.Crypto;
import com.taotao.cloud.crypto.ext.processor.HttpCryptoProcessor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(EncryptResponseBodyAdvice.class);
    private HttpCryptoProcessor httpCryptoProcessor;

    public void setInterfaceCryptoProcessor(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> converterType) {
        String methodName = methodParameter.getMethod().getName();
        Crypto crypto = (Crypto)methodParameter.getMethodAnnotation(Crypto.class);
        boolean isSupports = ObjectUtils.isNotEmpty((Object)crypto) && crypto.responseEncrypt();
        log.trace("Is EncryptResponseBodyAdvice supports method [{}] ? Status is [{}].", (Object)methodName, (Object)isSupports);
        return isSupports;
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String sessionKey = (String)request.getHeaders().get((Object)"session_key").get(0);
        if (StringUtils.isBlank((CharSequence)sessionKey)) {
            log.warn("Cannot find Herodotus Cloud custom session header. Use interface crypto founction need add X_HERODOTUS_SESSION to request header.");
            return body;
        }
        log.info("EncryptResponseBodyAdvice begin encrypt data.");
        String methodName = methodParameter.getMethod().getName();
        String className = methodParameter.getDeclaringClass().getName();
        String bodyString = JsonUtils.toJson((Object)body);
        String result = this.httpCryptoProcessor.encrypt(sessionKey, bodyString);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            log.debug("Encrypt response body for rest method [{}] in [{}] finished.", (Object)methodName, (Object)className);
            return result;
        }
        return body;
    }
}

