/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.crypto.ext.processor;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import com.taotao.cloud.crypto.ext.processor.SymmetricCryptoProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCryptoProcessor
implements SymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(AESCryptoProcessor.class);

    @Override
    public String createKey() {
        return RandomUtil.randomStringUpper((int)16);
    }

    @Override
    public String decrypt(String data, String key) {
        AES aes = SecureUtil.aes((byte[])StrUtil.utf8Bytes((CharSequence)key));
        byte[] result = aes.decrypt(Base64.decode((byte[])StrUtil.utf8Bytes((CharSequence)data)));
        log.debug("AES crypto decrypt data, value is : [{}]", (Object)result);
        return StrUtil.utf8Str((Object)result);
    }

    @Override
    public String encrypt(String data, String key) {
        AES aes = SecureUtil.aes((byte[])StrUtil.utf8Bytes((CharSequence)key));
        byte[] result = aes.encrypt(StrUtil.utf8Bytes((CharSequence)data));
        log.debug("AES crypto encrypt data, value is : [{}]", (Object)result);
        return StrUtil.utf8Str((Object)result);
    }
}

