/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.crypto.ext.processor;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.taotao.cloud.common.constant.SymbolConstants;
import com.taotao.cloud.crypto.ext.processor.AsymmetricCryptoProcessor;
import com.taotao.cloud.crypto.ext.processor.SecretKey;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACryptoProcessor
implements AsymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(RSACryptoProcessor.class);
    private static final String PKCS8_PUBLIC_KEY_BEGIN = "-----BEGIN PUBLIC KEY-----";
    private static final String PKCS8_PUBLIC_KEY_END = "-----END PUBLIC KEY-----";

    @Override
    public SecretKey createSecretKey() {
        RSA rsa = SecureUtil.rsa();
        SecretKey secretKey = new SecretKey();
        secretKey.setPrivateKey(rsa.getPrivateKeyBase64());
        secretKey.setPublicKey(this.appendPkcs8Padding(rsa.getPublicKeyBase64()));
        return secretKey;
    }

    private String removePkcs8Padding(String key) {
        String result = StringUtils.replace((String)key, (String)SymbolConstants.NEW_LINE, (String)SymbolConstants.BLANK);
        Object[] values = StringUtils.split((String)result, (String)"-----");
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            return values[1];
        }
        return key;
    }

    public String appendPkcs8Padding(String key) {
        return PKCS8_PUBLIC_KEY_BEGIN + SymbolConstants.NEW_LINE + key + SymbolConstants.NEW_LINE + PKCS8_PUBLIC_KEY_END;
    }

    @Override
    public String decrypt(String content, String privateKey) {
        byte[] base64Data = Base64.decode((CharSequence)content);
        RSA rsa = SecureUtil.rsa((String)privateKey, null);
        String result = StrUtil.utf8Str((Object)rsa.decrypt(base64Data, KeyType.PrivateKey));
        log.debug("RSA crypto decrypt data, value is : [{}]", (Object)result);
        return result;
    }

    @Override
    public String encrypt(String content, String publicKey) {
        String key = this.removePkcs8Padding(publicKey);
        RSA rsa = SecureUtil.rsa(null, (String)key);
        byte[] encryptedData = rsa.encrypt(content, KeyType.PublicKey);
        String result = Base64.encode((byte[])encryptedData);
        log.debug("RSA crypto decrypt data, value is : [{}]", (Object)result);
        return result;
    }
}

