/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.crypto.ext.processor;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import com.taotao.cloud.crypto.ext.processor.SymmetricCryptoProcessor;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4CryptoProcessor
implements SymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(SM4CryptoProcessor.class);

    @Override
    public String createKey() {
        SM4 sm4 = SmUtil.sm4();
        SecretKey secretKey = sm4.getSecretKey();
        byte[] encoded = secretKey.getEncoded();
        String result = HexUtil.encodeHexStr((byte[])encoded);
        log.debug("SM4 crypto create hex key, value is : [{}]", (Object)result);
        return result;
    }

    @Override
    public String decrypt(String data, String key) {
        SM4 sm4 = SmUtil.sm4((byte[])HexUtil.decodeHex((String)key));
        log.debug("SM4 crypto decrypt data [{}] with key : [{}]", (Object)data, (Object)key);
        String result = sm4.decryptStr(data);
        log.debug("SM4 crypto decrypt result is : [{}]", (Object)result);
        return result;
    }

    @Override
    public String encrypt(String data, String key) {
        SM4 sm4 = SmUtil.sm4((byte[])HexUtil.decodeHex((String)key));
        log.debug("SM4 crypto encrypt data [{}] with key : [{}]", (Object)data, (Object)key);
        String result = sm4.encryptHex(data);
        log.debug("SM4 crypto encrypt result is : [{}]", (Object)result);
        return result;
    }
}

